/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.cpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.cpa.DecisionUpdate;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class DecisionUpdater {
    private final DecisionUpdate update;
    private final AtsApi atsApi;

    public DecisionUpdater(DecisionUpdate update, AtsApi atsApi) {
        this.update = update;
        this.atsApi = atsApi;
    }

    public XResultData update() {
        XResultData rd = new XResultData(false);
        Collection teamWfs = this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andAtsIds((Collection)this.update.getIds()).getItems();
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Update CPA Decision", AtsCoreUsers.SYSTEM_USER);
        for (IAtsTeamWorkflow teamWf : teamWfs) {
            if (!rd.isErrors()) {
                this.updateRationale(this.update, changes, teamWf, rd);
            }
            if (!rd.isErrors()) {
                this.updateDuplicatedPcrId(this.update, changes, teamWf, rd);
            }
            if (!rd.isErrors()) {
                this.updateApplicability(this.update, changes, teamWf, rd);
            }
            if (rd.isErrors()) continue;
            this.updateAssignees(this.update, changes, teamWf, rd);
        }
        if (!rd.isErrors() && !changes.isEmpty()) {
            changes.execute();
        }
        return rd;
    }

    private void updateApplicability(DecisionUpdate update, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, XResultData rd) {
        if (update.getApplicability() != null) {
            String appl = update.getApplicability();
            if (appl.isEmpty()) {
                changes.deleteAttributes((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.ApplicableToProgram);
                TransitionHelper helper = new TransitionHelper("Transition " + teamWf.getAtsId(), Arrays.asList(teamWf), TeamState.Analyze.getName(), (Collection)teamWf.getAssignees(), "", changes, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
                helper.setTransitionUser(AtsCoreUsers.SYSTEM_USER);
                TransitionManager mgr = new TransitionManager((ITransitionHelper)helper);
                TransitionResults results = mgr.handleAll();
                if (!results.isEmpty()) {
                    rd.error(results.toString());
                }
            } else {
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.ApplicableToProgram, appl);
                TransitionHelper helper = new TransitionHelper("Transition " + teamWf.getAtsId(), Arrays.asList(teamWf), TeamState.Completed.getName(), null, "", changes, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
                helper.setTransitionUser(AtsCoreUsers.SYSTEM_USER);
                TransitionManager mgr = new TransitionManager((ITransitionHelper)helper);
                TransitionResults results = mgr.handleAll();
                if (!results.isEmpty()) {
                    rd.error(results.toString());
                }
            }
        }
    }

    private void updateAssignees(DecisionUpdate update, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, XResultData rd) {
        if (update.getAssignees() != null) {
            ArrayList<AtsUser> assignees = new ArrayList<AtsUser>();
            for (String userId : update.getAssignees()) {
                AtsUser user = this.atsApi.getUserService().getUserByUserId(userId);
                if (user == null) {
                    rd.errorf("Invalid userId [%s]", new Object[]{userId});
                }
                assignees.add(user);
            }
            List currentAssignees = teamWf.getAssignees();
            if (assignees.isEmpty()) {
                assignees.add(AtsCoreUsers.UNASSIGNED_USER);
            } else if (assignees.size() > 1 && assignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
                assignees.remove(AtsCoreUsers.UNASSIGNED_USER);
            }
            if (!Collections.isEqual((Collection)currentAssignees, assignees)) {
                teamWf.getStateMgr().setAssignees(assignees);
                changes.add((Object)teamWf);
            }
        }
    }

    private void updateRationale(DecisionUpdate update, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, XResultData rd) {
        if (update.getRationale() != null) {
            if (update.getRationale().equals("")) {
                changes.deleteAttributes((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.Rationale);
            } else {
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.Rationale, update.getRationale());
            }
        }
    }

    private void updateDuplicatedPcrId(DecisionUpdate update, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, XResultData rd) {
        if (update.getDuplicatedPcrId() != null) {
            if (update.getDuplicatedPcrId().equals("")) {
                changes.deleteAttributes((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.DuplicatedPcrId);
            } else {
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.DuplicatedPcrId, update.getDuplicatedPcrId());
            }
        }
    }
}

