/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.writers;

import javax.ws.rs.ext.Provider;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.jaxrs.server.internal.resources.AbstractHtmlWriter;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ClientRegistrationData;
import org.eclipse.osee.jaxrs.server.internal.security.util.HiddenFormFields;

@Provider
public class ClientRegistrationDataHtmlWriter
extends AbstractHtmlWriter<ClientRegistrationData> {
    private static final String CLIENT_REG_FORM__TEMPLATE = "client_registration_form.html";
    private static final String CLIENT_REG_FORM__REPLY_TO_TAG = "replyTo";
    private static final String CLIENT_REG_FORM__REGISTRATION_DECISION = "registrationDecisionKey";
    private static final String CLIENT_REG_FORM__REGISTRATION_DECISION_CANCEL = "registrationDecisionCancel";
    private static final String CLIENT_REG_FORM__REGISTRATION_DECISION_ACCEPT = "registrationDecisionAccept";
    private static final String CLIENT_REG_FORM__HIDDEN_FIELDS_SECTION_TAG = "hiddenFieldsSection";

    @Override
    public Class<ClientRegistrationData> getSupportedClass() {
        return ClientRegistrationData.class;
    }

    @Override
    public ViewModel asViewModel(ClientRegistrationData data) {
        ViewModel model = new ViewModel(CLIENT_REG_FORM__TEMPLATE);
        model.param(CLIENT_REG_FORM__REPLY_TO_TAG, (Object)JaxRsUtils.asTemplateValue(data.getReplyTo()));
        model.param(CLIENT_REG_FORM__REGISTRATION_DECISION, (Object)"applicationRegistrationDecision");
        model.param(CLIENT_REG_FORM__REGISTRATION_DECISION_ACCEPT, (Object)"register");
        model.param(CLIENT_REG_FORM__REGISTRATION_DECISION_CANCEL, (Object)"cancel");
        model.param(CLIENT_REG_FORM__HIDDEN_FIELDS_SECTION_TAG, (Object)HiddenFormFields.newForm().add("applicationGuid", data.getClientGuid()).add("session_authenticity_token", data.getAuthenticityToken()).build());
        return model;
    }
}

