/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security;

import java.security.Principal;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;

@Provider
@PreMatching
public class AnonymousPrincipalRequestFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) {
        javax.ws.rs.core.SecurityContext sc = requestContext.getSecurityContext();
        Principal principal = sc.getUserPrincipal();
        if (principal == null) {
            SecurityContext securityContext = OAuthUtil.newSecurityContext(OseePrincipal.Anonymous);
            MessageContext mc = this.getMessageContext();
            OAuthUtil.saveSecurityContext(mc, securityContext);
        }
    }

    public MessageContext getMessageContext() {
        return new MessageContextImpl(PhaseInterceptorChain.getCurrentMessage());
    }
}

