/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.logging;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.framework.logging.IHealthStatus;
import org.eclipse.osee.framework.logging.IStatusListener;
import org.eclipse.osee.framework.logging.IStatusListenerFilter;

class StatusManager {
    private final Map<String, IHealthStatus> services = Collections.synchronizedMap(new TreeMap());
    private final List<IStatusListener> listeners = new CopyOnWriteArrayList<IStatusListener>();
    private final Map<IStatusListener, IStatusListenerFilter> filters = new ConcurrentHashMap<IStatusListener, IStatusListenerFilter>();

    public void report(IHealthStatus status) {
        if (status != null) {
            IHealthStatus storedStatus = this.services.get(status.getSourceName());
            if (storedStatus == null) {
                this.services.put(status.getSourceName(), status);
            }
            for (IStatusListener listener : this.listeners) {
                IStatusListenerFilter filter = this.filters.get(listener);
                if (filter != null && !filter.isInterested(status)) continue;
                listener.onStatus(status);
            }
        }
    }

    public boolean register(IStatusListener listener, IStatusListenerFilter filter) {
        this.filters.put(listener, filter);
        return this.listeners.add(listener);
    }

    public boolean register(IStatusListener listener) {
        return this.listeners.add(listener);
    }

    public boolean deregister(IStatusListener listener) {
        return this.listeners.remove(listener);
    }

    public Collection<IHealthStatus> getHealthStatus() {
        return this.services.values();
    }

    public boolean isStatusOk() {
        boolean result = true;
        for (IHealthStatus status : this.getHealthStatus()) {
            result &= status.isOk();
        }
        return result;
    }

    public String getReport() {
        StringBuilder message = new StringBuilder();
        Collection<IHealthStatus> serviceInfos = this.getHealthStatus();
        for (IHealthStatus status : serviceInfos) {
            message.append(status.getSourceName().toUpperCase());
            if (!status.isOk()) {
                message.append(" - ERROR - ");
            } else {
                message.append(" - OK - ");
            }
            message.append(status.getMessage());
            message.append("\n\n");
        }
        return message.toString();
    }

    public IHealthStatus getHealthStatusByName(String sourceName) {
        return this.services.get(sourceName);
    }
}

