/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.util;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.jdbc.JdbcMigrationResource;
import org.eclipse.osee.logger.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DynamicSchemaResourceProvider
implements Supplier<Iterable<JdbcMigrationResource>> {
    private final Log logger;

    public DynamicSchemaResourceProvider(Log logger) {
        this.logger = logger;
    }

    public Iterable<JdbcMigrationResource> get() {
        ArrayList<JdbcMigrationResource> resources = new ArrayList<JdbcMigrationResource>();
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext context = bundle.getBundleContext();
        try {
            Collection references = context.getServiceReferences(JdbcMigrationResource.class, null);
            for (ServiceReference ref : references) {
                JdbcMigrationResource resource = (JdbcMigrationResource)context.getService(ref);
                resources.add(resource);
            }
        }
        catch (InvalidSyntaxException ex) {
            this.logger.warn(ex.toString(), new Object[]{ex});
        }
        return resources;
    }
}

