/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DataFactory;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.DataFactoryImpl;
import org.eclipse.osee.orcs.db.internal.loader.DataLoaderFactoryImpl;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.handlers.LoaderSqlHandlerFactoryUtil;
import org.eclipse.osee.orcs.db.internal.loader.processor.DynamicLoadProcessor;
import org.eclipse.osee.orcs.db.internal.proxy.AttributeDataProxyFactory;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class LoaderModule {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final IdentityManager idFactory;
    private final SqlJoinFactory joinFactory;
    private final IResourceManager resourceManager;

    public LoaderModule(Log logger, JdbcClient jdbcClient, IdentityManager idFactory, SqlJoinFactory joinFactory, IResourceManager resourceManager) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.idFactory = idFactory;
        this.joinFactory = joinFactory;
        this.resourceManager = resourceManager;
    }

    public AttributeDataProxyFactory createProxyDataFactory() {
        return new AttributeDataProxyFactory(this.resourceManager, this.logger);
    }

    public DataFactory createDataFactory(OrcsObjectFactory factory) {
        return new DataFactoryImpl(this.idFactory, factory);
    }

    public DynamicLoadProcessor createDynamicLoadProcessor(OrcsTokenService tokenService, AttributeDataProxyFactory proxyFactory) {
        return new DynamicLoadProcessor(this.logger, tokenService, proxyFactory);
    }

    public DataLoaderFactory createDataLoaderFactory(SqlObjectLoader sqlObjectLoader) {
        return new DataLoaderFactoryImpl(this.logger, this.jdbcClient, sqlObjectLoader, this.joinFactory);
    }

    public SqlObjectLoader createSqlObjectLoader(OrcsObjectFactory objectFactory, DynamicLoadProcessor dynamicLoadProcessor, OrcsTokenService tokenService) {
        SqlHandlerFactory handlerFactory = LoaderSqlHandlerFactoryUtil.createHandlerFactory();
        return new SqlObjectLoader(this.logger, this.jdbcClient, this.joinFactory, handlerFactory, objectFactory, dynamicLoadProcessor, tokenService);
    }
}

