/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.transform;

import java.util.Collection;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.transform.ExchangeDataProcessor;
import org.eclipse.osee.orcs.db.internal.exchange.transform.IExchangeTransformProvider;
import org.eclipse.osee.orcs.db.internal.exchange.transform.IOseeExchangeVersionTransformer;
import org.eclipse.osee.orcs.db.internal.exchange.transform.ManifestVersionRule;
import org.osgi.framework.Version;

public class ExchangeTransformer {
    private final Log logger;
    private final OrcsSession session;
    private final JdbcClient jdbcClient;
    private final IExchangeTransformProvider provider;
    private final ExchangeDataProcessor processor;
    private Collection<IOseeExchangeVersionTransformer> transformers;

    public ExchangeTransformer(Log logger, OrcsSession session, JdbcClient jdbcClient, IExchangeTransformProvider provider, ExchangeDataProcessor processor) {
        this.logger = logger;
        this.session = session;
        this.jdbcClient = jdbcClient;
        this.provider = provider;
        this.processor = processor;
    }

    public void applyTransforms() throws Exception {
        Version exchangeVersion = this.getExchangeManifestVersion();
        this.transformers = this.provider.getApplicableTransformers(exchangeVersion);
        ManifestVersionRule versionRule = new ManifestVersionRule();
        versionRule.setVersion(exchangeVersion);
        versionRule.setReplaceVersion(true);
        for (IOseeExchangeVersionTransformer transformer : this.transformers) {
            Version newVersion = transformer.applyTransform(this.processor, this.logger);
            versionRule.setVersion(newVersion);
            this.processor.transform(ExportItem.EXPORT_MANIFEST, versionRule);
        }
    }

    public void applyFinalTransforms() throws Exception {
        Conditions.checkNotNull(this.transformers, (String)"transformers", (String)"forgot to call apply transforms first", (Object[])new Object[0]);
        for (IOseeExchangeVersionTransformer transform : this.transformers) {
            transform.finalizeTransform(this.logger, this.session, this.jdbcClient, this.processor);
        }
        this.transformers = null;
    }

    public Version getExchangeManifestVersion() {
        ManifestVersionRule versionRule = new ManifestVersionRule();
        versionRule.setReplaceVersion(false);
        this.processor.transform(ExportItem.EXPORT_MANIFEST, versionRule);
        String version = versionRule.getVersion();
        return Strings.isValid((String)version) ? new Version(version) : new Version("0.0.0");
    }
}

