/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.conflict;

import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.ConflictType;
import org.eclipse.osee.framework.core.enums.StorageState;
import org.eclipse.osee.framework.core.model.IOseeStorable;
import org.eclipse.osee.framework.core.model.MergeBranch;
import org.eclipse.osee.framework.jdk.core.type.Id;

public final class Conflict
implements IOseeStorable {
    private final MergeBranch mergeBranch;
    private final ConflictStatus conflictStatus;
    private final Id itemId;
    private final GammaId sourceGammaId;
    private final GammaId destinationGammaId;
    private final ConflictType conflictType;
    private StorageState storageState;
    private boolean isDirty;

    public Conflict(StorageState storageState, Id itemId, ConflictType conflictType, MergeBranch mergeBranch, ConflictStatus conflictStatus, GammaId sourceGammaId, GammaId destinationGammaId) {
        this.mergeBranch = mergeBranch;
        this.storageState = storageState;
        this.conflictStatus = conflictStatus;
        this.itemId = itemId;
        this.conflictType = conflictType;
        this.sourceGammaId = sourceGammaId;
        this.destinationGammaId = destinationGammaId;
        this.isDirty = false;
    }

    public ConflictType getType() {
        return this.conflictType;
    }

    public GammaId getSourceGammaId() {
        return this.sourceGammaId;
    }

    public GammaId getDestinationGammaId() {
        return this.destinationGammaId;
    }

    public Id getId() {
        return this.itemId;
    }

    public MergeBranch getMergeBranch() {
        return this.mergeBranch;
    }

    public ConflictStatus getStatus() {
        return this.conflictStatus;
    }

    public StorageState getStorageState() {
        return this.storageState;
    }

    public void clearDirty() {
        this.isDirty = false;
        this.storageState = StorageState.LOADED;
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

