/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.branch;

import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.SystemProperties;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.data.ArchiveOperation;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.ArchiveUnarchiveBranchCallable;
import org.eclipse.osee.orcs.db.internal.callable.BranchCopyTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.BranchInheritACLCallable;
import org.eclipse.osee.orcs.db.internal.callable.ChangeBranchFieldCallable;
import org.eclipse.osee.orcs.db.internal.callable.CheckBranchExchangeIntegrityCallable;
import org.eclipse.osee.orcs.db.internal.callable.CommitBranchDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.CompositeDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.CreateBranchDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.ExportBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.callable.ImportBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.callable.PurgeBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.change.LoadDeltasBetweenTxsOnTheSameBranch;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactoryImpl;
import org.eclipse.osee.orcs.db.internal.exchange.ExportItemFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;

public class BranchModule {
    private final String INSERT_INTO_BRANCH_ACL = "INSERT INTO OSEE_BRANCH_ACL (permission_id, privilege_entity_id, branch_id) VALUES (?, ?, ?)";
    private final String UPDATE_BRANCH_ACL = "UPDATE OSEE_BRANCH_ACL SET permission_id = ? WHERE privilege_entity_id = ? AND branch_id = ?";
    private final String GET_BRANCH_PERMISSION = "SELECT permission_id FROM osee_branch_acl WHERE privilege_entity_id = ? AND branch_id = ?";
    private static final String COPY_APPLIC = "INSERT INTO osee_txs (branch_id, gamma_id, transaction_id, tx_current, mod_type, app_id)\nwith cte as (select branch_id as chid, baseline_transaction_id as chtx, parent_branch_id as pid from osee_branch where branch_id = ?)\nselect chid, txsP.gamma_id, chtx, tx_current, mod_type, app_id from cte, osee_tuple2 t2, osee_txs txsP where tuple_type = 2 and t2.gamma_id = txsP.gamma_id and txsP.branch_id = pid and txsP.tx_current =1 and not exists (select 1 from osee_txs txsC where txsC.branch_id = chid and txsC.gamma_id = txsP.gamma_id)";
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final IdentityManager idManager;
    private final SystemProperties preferences;
    private final ExecutorAdmin executorAdmin;
    private final IResourceManager resourceManager;

    public BranchModule(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory, IdentityManager idManager, SystemProperties preferences, ExecutorAdmin executorAdmin, IResourceManager resourceManager) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.idManager = idManager;
        this.preferences = preferences;
        this.executorAdmin = executorAdmin;
        this.resourceManager = resourceManager;
    }

    public BranchDataStore createBranchDataStore(DataLoaderFactory dataLoaderFactory) {
        final MissingChangeItemFactoryImpl missingChangeItemFactory = new MissingChangeItemFactoryImpl(dataLoaderFactory);
        return new BranchDataStore(){

            public void addMissingApplicabilityFromParentBranch(BranchId branch) {
                BranchModule.this.jdbcClient.runPreparedUpdate(BranchModule.COPY_APPLIC, new Object[]{branch});
            }

            public void createBranch(CreateBranchData branchData) {
                BranchModule.this.jdbcClient.runTransaction((JdbcTransaction)new CreateBranchDatabaseTxCallable(BranchModule.this.jdbcClient, BranchModule.this.idManager, branchData, OseeCodeVersion.getVersionId()));
                if (branchData.isInheritAccess()) {
                    BranchModule.this.jdbcClient.runTransaction((JdbcTransaction)new BranchInheritACLCallable(BranchModule.this.jdbcClient, branchData));
                }
            }

            public XResultData createBranchValidation(CreateBranchData branchData) {
                return new CreateBranchDatabaseTxCallable(BranchModule.this.jdbcClient, BranchModule.this.idManager, branchData, OseeCodeVersion.getVersionId()).checkPreconditions(BranchModule.this.jdbcClient.getConnection());
            }

            public void createBranchCopyTx(CreateBranchData branchData) {
                BranchModule.this.jdbcClient.runTransaction((JdbcTransaction)new BranchCopyTxCallable(BranchModule.this.jdbcClient, BranchModule.this.idManager, branchData, OseeCodeVersion.getVersionId()));
            }

            public TransactionId commitBranch(OrcsSession session, ArtifactId committer, OrcsTokenService tokenService, Branch source, TransactionToken sourceTx, Branch destination, TransactionToken destinationTx, QueryFactory queryFactory) {
                BranchId mergeBranch = this.getMergeBranchId(queryFactory.branchQuery(), (BranchId)source, (BranchId)destination);
                try {
                    return (TransactionId)new CommitBranchDatabaseTxCallable(BranchModule.this.idManager, committer, BranchModule.this.jdbcClient, BranchModule.this.joinFactory, tokenService, source, (BranchId)destination, sourceTx, destinationTx, mergeBranch, queryFactory, missingChangeItemFactory).call();
                }
                catch (Exception ex) {
                    throw OseeCoreException.wrap((Throwable)ex);
                }
            }

            public Callable<Void> purgeBranch(OrcsSession session, Branch toDelete) {
                return new PurgeBranchDatabaseCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, toDelete);
            }

            public List<ChangeItem> compareBranch(OrcsSession session, OrcsTokenService tokenService, TransactionToken sourceTx, TransactionToken destinationTx, QueryFactory queryFactory) {
                BranchId mergeBranch = this.getMergeBranchId(queryFactory.branchQuery(), sourceTx.getBranch(), destinationTx.getBranch());
                return new LoadDeltasBetweenTxsOnTheSameBranch(BranchModule.this.jdbcClient, BranchModule.this.joinFactory, tokenService, sourceTx, destinationTx, mergeBranch, queryFactory, missingChangeItemFactory).compareTransactions();
            }

            private BranchId getMergeBranchId(BranchQuery branchQuery, BranchId source, BranchId destination) {
                BranchId mergeBranch = (BranchId)((BranchQuery)branchQuery.andIsMergeFor(source, destination)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
                if (mergeBranch.isInvalid()) {
                    mergeBranch = BranchId.SENTINEL;
                }
                return mergeBranch;
            }

            public Callable<URI> exportBranch(OrcsSession session, List<? extends BranchId> branches, PropertyStore options, String exportName) {
                ExportItemFactory factory = new ExportItemFactory(BranchModule.this.logger, BranchModule.this.preferences, BranchModule.this.jdbcClient, BranchModule.this.resourceManager);
                return new ExportBranchDatabaseCallable(session, factory, BranchModule.this.joinFactory, BranchModule.this.preferences, BranchModule.this.executorAdmin, branches, options, exportName);
            }

            public Callable<URI> importBranch(OrcsSession session, URI fileToImport, List<? extends BranchId> branches, PropertyStore options) {
                ImportBranchDatabaseCallable callable = new ImportBranchDatabaseCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, BranchModule.this.preferences, BranchModule.this.resourceManager, fileToImport, branches, options);
                return callable;
            }

            public Callable<URI> checkBranchExchangeIntegrity(OrcsSession session, URI fileToCheck) {
                return new CheckBranchExchangeIntegrityCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, BranchModule.this.preferences, BranchModule.this.resourceManager, fileToCheck);
            }

            public Callable<Void> changeBranchState(OrcsSession session, BranchId branch, BranchState branchState) {
                return ChangeBranchFieldCallable.newBranchState(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, branchState);
            }

            public Callable<Void> changeBranchType(OrcsSession session, BranchId branch, BranchType branchType) {
                return ChangeBranchFieldCallable.newBranchType(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, branchType);
            }

            public Callable<Void> changeBranchName(OrcsSession session, BranchId branch, String branchName) {
                return ChangeBranchFieldCallable.newBranchName(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, branchName);
            }

            public Callable<Void> changeBranchAssociatedArt(OrcsSession session, BranchId branch, ArtifactId assocArt) {
                return ChangeBranchFieldCallable.newAssocArtId(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, assocArt);
            }

            public Callable<Void> archiveUnArchiveBranch(OrcsSession session, BranchId branch, ArchiveOperation op) {
                return new ArchiveUnarchiveBranchCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, op);
            }

            public Callable<Void> deleteBranch(OrcsSession session, BranchId branch) {
                AbstractDatastoreTxCallable deleteBranch = (AbstractDatastoreTxCallable)((Object)this.changeBranchState(session, branch, BranchState.DELETED));
                AbstractDatastoreTxCallable archiveBranch = (AbstractDatastoreTxCallable)((Object)this.archiveUnArchiveBranch(session, branch, ArchiveOperation.ARCHIVE));
                CompositeDatastoreTxCallable composite = new CompositeDatastoreTxCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, deleteBranch, archiveBranch);
                return composite;
            }

            public void setBranchPermission(ArtifactId subject, BranchId branch, PermissionEnum permission) {
                int existingPermission = (Integer)BranchModule.this.jdbcClient.fetch((Object)-1, "SELECT permission_id FROM osee_branch_acl WHERE privilege_entity_id = ? AND branch_id = ?", new Object[]{subject, branch});
                String sql = existingPermission == -1 ? "INSERT INTO OSEE_BRANCH_ACL (permission_id, privilege_entity_id, branch_id) VALUES (?, ?, ?)" : "UPDATE OSEE_BRANCH_ACL SET permission_id = ? WHERE privilege_entity_id = ? AND branch_id = ?";
                BranchModule.this.jdbcClient.runPreparedUpdate(sql, new Object[]{permission.getPermId(), subject, branch});
            }
        };
    }
}

