/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

public class Streams {
    private static final int ORACLE_BUFF_LENGTH = 32768;

    public static InputStream convertStringToInputStream(String string, String charSet) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(string.getBytes(charSet));
    }

    public static byte[] getByteArray(InputStream stream) {
        if (stream == null) {
            throw new IllegalStateException("stream can not be null");
        }
        int length = -1;
        long read = 0L;
        byte[] data = new byte[32768];
        LinkedList<byte[]> linkedByteArrays = new LinkedList<byte[]>();
        try {
            while ((length = stream.read(data)) != -1) {
                linkedByteArrays.add(data);
                data = new byte[32768];
                if ((read += (long)length) <= Integer.MAX_VALUE) continue;
                throw new UnsupportedOperationException("The data is too large.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        data = new byte[(int)read];
        int index = 0;
        for (byte[] chunk : linkedByteArrays) {
            int writeSize = Math.min((int)read, 32768);
            System.arraycopy(chunk, 0, data, index, writeSize);
            read -= (long)writeSize;
            index += writeSize;
        }
        return data;
    }
}

