/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class UrlQuery {
    private static final String URL_ENCODING = "UTF-8";
    private final Map<String, List<String>> parameters = new TreeMap<String, List<String>>();

    public UrlQuery clear() {
        this.parameters.clear();
        return this;
    }

    public boolean containsKey(String key) {
        return this.parameters.containsKey(key);
    }

    public UrlQuery put(String name, String ... values) {
        this.put(name, false, values);
        return this;
    }

    public UrlQuery put(String name, Object ... values) {
        this.put(name, false, values);
        return this;
    }

    public UrlQuery putInPlace(String name, String ... values) {
        this.put(name, true, values);
        return this;
    }

    public UrlQuery putInPlace(String name, Object ... values) {
        this.put(name, true, values);
        return this;
    }

    private UrlQuery put(String name, boolean overrite, String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (Strings.isValid(value)) {
                this.innerPut(name, value, overrite);
            }
            ++n2;
        }
        return this;
    }

    private UrlQuery put(String name, boolean overrite, Object ... values) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value != null) {
                this.innerPut(name, String.valueOf(value), overrite);
            }
            ++n2;
        }
        return this;
    }

    private void innerPut(String name, String value, boolean overrite) {
        List<String> list = this.parameters.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.parameters.put(name, list);
        }
        if (overrite) {
            list.clear();
        }
        list.add(value);
    }

    private void innerPut(String name, String value) {
        this.innerPut(name, value, false);
    }

    public UrlQuery parse(URL url) throws UnsupportedEncodingException {
        if (url != null) {
            this.parse(url.getQuery());
        }
        return this;
    }

    public UrlQuery parse(String qs) throws UnsupportedEncodingException {
        this.clear();
        if (Strings.isValid(qs)) {
            String[] pairs;
            String toParse = qs;
            int pos = toParse.lastIndexOf(47);
            if (pos > -1) {
                toParse = toParse.substring(pos + 1);
            }
            if ((pos = toParse.lastIndexOf(63)) > -1) {
                toParse = toParse.substring(pos + 1);
            }
            String[] stringArray = pairs = toParse.split("&");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String name;
                String pair = stringArray[n2];
                pos = pair.indexOf(61);
                if (pos == -1) {
                    name = pair;
                    value = null;
                } else {
                    name = UrlQuery.decode(pair.substring(0, pos));
                    value = UrlQuery.decode(pair.substring(pos + 1, pair.length()));
                }
                this.innerPut(name, value);
                ++n2;
            }
        }
        return this;
    }

    public String getParameter(String name) {
        List<String> values = this.parameters.get(name);
        String toReturn = values == null ? null : (values.isEmpty() ? "" : values.iterator().next());
        return toReturn;
    }

    public String[] getParameterValues(String name) {
        List<String> values = this.parameters.get(name);
        return values != null ? values.toArray(new String[values.size()]) : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map<String, String[]> getParameterMap() {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            List<String> list = entry.getValue();
            String[] values = list != null ? list.toArray(new String[list.size()]) : null;
            map.put(entry.getKey(), values);
        }
        return map;
    }

    public String toUrl() throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            Collection values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            for (String value : values) {
                if (!isFirst) {
                    builder.append('&');
                }
                builder.append(UrlQuery.encode(key));
                builder.append('=');
                builder.append(UrlQuery.encode(value));
                isFirst = false;
            }
        }
        return builder.toString();
    }

    public String toString() {
        try {
            return this.toUrl();
        }
        catch (UnsupportedEncodingException ex) {
            return Lib.exceptionToString(ex);
        }
    }

    private static String decode(String value) throws UnsupportedEncodingException {
        return URLDecoder.decode(value, URL_ENCODING);
    }

    private static String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, URL_ENCODING);
    }
}

