/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSetIterable;
import org.eclipse.osee.framework.jdk.core.type.ResultSetList;

public final class ResultSets {
    private static final ResultSet EMPTY_RESULT_SET = new ResultSetList(Collections.emptyList());

    private ResultSets() {
    }

    public static <T> ResultSet<T> newResultSet(T ... item) {
        ResultSet<T> toReturn = item == null || item.length <= 0 ? ResultSets.emptyResultSet() : ResultSets.newResultSet(Arrays.asList(item));
        return toReturn;
    }

    public static <T> ResultSet<T> singleton(T item) {
        ResultSet<T> toReturn = item == null ? ResultSets.emptyResultSet() : new ResultSetList<T>(Collections.singletonList(item));
        return toReturn;
    }

    public static <T> ResultSet<T> newResultSet(List<T> list) {
        ResultSet<T> toReturn = list == null || list.isEmpty() ? ResultSets.emptyResultSet() : new ResultSetList<T>(list);
        return toReturn;
    }

    public static <T> ResultSet<T> newResultSet(Iterable<T> iterable) {
        ResultSet<T> toReturn = iterable == null || !iterable.iterator().hasNext() ? ResultSets.emptyResultSet() : new ResultSetIterable<T>(iterable);
        return toReturn;
    }

    public static <T> ResultSet<T> emptyResultSet() {
        return EMPTY_RESULT_SET;
    }

    public static <T, R> ResultSet<R> transform(ResultSet<T> inputSet, Function<T, R> factory) {
        if (inputSet == null || inputSet.isEmpty()) {
            return ResultSets.emptyResultSet();
        }
        ArrayList data = new ArrayList(inputSet.size());
        inputSet.forEach(in -> {
            boolean bl = data.add(factory.apply(in));
        });
        return new ResultSetList(data);
    }
}

