/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.rules;

import java.io.File;
import java.io.IOException;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;

public class HtmlTableBuilder
extends Rule {
    public HtmlTableBuilder() {
        super("html");
    }

    @Override
    public ChangeSet computeChanges(CharSequence seq) {
        ChangeSet changeSet = new ChangeSet(seq);
        changeSet.insertBefore(0, "<html>\n<body>\n<table cellpadding=2 cellspacing=0 border=1>\n".toCharArray());
        char[] rowStartChars = new char[]{'\t', '<', 't', 'r', '>', '\n'};
        char[] cellStartChars = "\t\t<td>".toCharArray();
        char[] cellEndChars = "</td>\n".toCharArray();
        char[] rowEndChars = new char[]{'\t', '<', '/', 't', 'r', '>', '\n'};
        int lineStart = 0;
        int lineEnd = 0;
        int length = seq.length();
        int i = 0;
        while (i < length) {
            if (seq.charAt(i) == '\n') {
                lineEnd = i + 1;
                changeSet.insertBefore(lineStart, rowStartChars);
                int tabStart = lineStart;
                int k = lineStart;
                while (k < lineEnd) {
                    if (seq.charAt(k) == '\t' || k == i) {
                        changeSet.insertBefore(tabStart, cellStartChars);
                        tabStart = k + 1;
                        changeSet.replace(k, tabStart, cellEndChars);
                    }
                    ++k;
                }
                changeSet.insertBefore(lineEnd, rowEndChars);
                lineStart = lineEnd;
            }
            ++i;
        }
        changeSet.insertBefore(length, "</table>\n</body>\n</html>".toCharArray());
        return changeSet;
    }

    public static void main(String[] args) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(System.getProperty("user.home"));
        buffer.append(File.separator);
        buffer.append(HtmlTableBuilder.class.getName());
        buffer.append(".table.txt");
        new HtmlTableBuilder().process(new File(buffer.toString()));
    }
}

