/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.data.write;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.CustomizedTeamWorkFlowArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.util.RestUtil;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.Activator;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class CustomizedTeamWorkFlowArtifactLoader {
    public static void copyArtifactReadbleToTransferableArtifact(ArtifactReadable readable, CustomizedTeamWorkFlowArtifact transArtifact) throws OseeCoreException {
        Collection existingAttributeTypes = readable.getExistingAttributeTypes();
        for (AttributeTypeToken iAttributeType : existingAttributeTypes) {
            ResultSet attributes = readable.getAttributes(iAttributeType);
            ArrayList<String> listTemp = new ArrayList<String>();
            for (AttributeReadable attributeReadable : attributes) {
                if (attributeReadable.getValue() != null) {
                    listTemp.add(attributeReadable.getValue().toString());
                    continue;
                }
                listTemp.add("");
            }
            transArtifact.putAttributes(iAttributeType.toString(), listTemp);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        transArtifact.putAttributes("guid", list2);
        transArtifact.setGuid(readable.getGuid());
        transArtifact.setName(readable.getName());
        Collection existingRelationTypes = readable.getExistingRelationTypes();
        try {
            for (RelationTypeToken iRelationType : existingRelationTypes) {
                RelationTypeSide createRelationTypeSide1;
                ResultSet relatedArtifacts1;
                RelationTypeSide createRelationTypeSide = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_B);
                ResultSet relatedArtifacts = readable.getRelated(createRelationTypeSide);
                if (relatedArtifacts.size() > 0) {
                    CustomizedTeamWorkFlowArtifactLoader.fillRelations((ResultSet<ArtifactReadable>)relatedArtifacts, createRelationTypeSide, iRelationType, transArtifact);
                }
                if ((relatedArtifacts1 = readable.getRelated(createRelationTypeSide1 = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_A))).size() <= 0) continue;
                CustomizedTeamWorkFlowArtifactLoader.fillRelations((ResultSet<ArtifactReadable>)relatedArtifacts1, createRelationTypeSide1, iRelationType, transArtifact);
            }
        }
        catch (Exception exception) {
            OseeLog.log(Activator.class, (Level)Level.WARNING, (String)" Exception while copying relations . Some relation will not be copied ");
        }
    }

    public static void copyArtifactReadbleToTransferableArtifactWithoutRelation(ArtifactReadable readable, CustomizedTeamWorkFlowArtifact transArtifact) throws OseeCoreException {
        ResultSet attributesRemainingHours;
        ResultSet attributesEstimatedHours;
        ResultSet attributesCompletionDate;
        ResultSet attributeEstimateComp;
        ResultSet attributesStory;
        ResultSet attributesCreatedDate;
        ResultSet attributesRank;
        ResultSet attributesCreatedBy;
        ResultSet attributesChange;
        ResultSet attributesprority;
        ResultSet attributesDes;
        ResultSet attributes;
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        transArtifact.putAttributes("guid", list2);
        transArtifact.setGuid(readable.getGuid());
        transArtifact.setName(readable.getName());
        transArtifact.setArtifactType(readable.getArtifactType().toString());
        ResultSet related = readable.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
        for (ArtifactReadable artifactReadable : related) {
            TransferableArtifact ar = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
            transArtifact.setVersion(ar);
        }
        ResultSet attributes1 = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.ActionableItem);
        if (attributes1 != null && attributes1.size() > 0) {
            for (AttributeReadable attributeReadable : attributes1) {
                String actionableGuid = (String)attributeReadable.getValue();
                OrcsApi orcsApi = OseeCoreData.getOrcsApi();
                ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andUuid(Long.valueOf(actionableGuid).longValue()).getResults();
                if (list == null || list.size() <= 0) continue;
                for (ArtifactReadable artifactReadable : list) {
                    ArtifactReadable teamArtifact = (ArtifactReadable)artifactReadable.getRelated(AtsRelationTypes.TeamActionableItem_TeamDefinition).getExactlyOne();
                    CustomizedTeamWorkFlowArtifactLoader.fillTeamMembersTeamLeads(teamArtifact, transArtifact);
                    TransferableArtifact ar = new TransferableArtifact();
                    TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                    transArtifact.setActionableItem(ar);
                }
            }
        }
        if ((attributes = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentState)) != null && attributes.size() > 0) {
            for (AttributeReadable attributeReadable : attributes) {
                String currentStateString = (String)attributeReadable.getValue();
                String currentState = RestUtil.getCurrentState((String)currentStateString);
                List<ITransferableArtifact> assignee = CommonUtil.getBasicAssignees(attributeReadable.getValue().toString());
                transArtifact.setAssignee(assignee);
                transArtifact.setCurrentState(currentState);
            }
        }
        if ((attributesDes = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.Description)) != null && attributesDes.size() > 0) {
            for (AttributeReadable attributeReadable : attributesDes) {
                String des = (String)attributeReadable.getValue();
                transArtifact.setDescription(des);
            }
        }
        if ((attributesprority = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.Priority)) != null && attributesprority.size() > 0) {
            for (AttributeReadable attributeReadable : attributesprority) {
                String pro = (String)attributeReadable.getValue();
                transArtifact.setPriority(pro);
            }
        }
        if ((attributesChange = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.ChangeType)) != null && attributesChange.size() > 0) {
            for (AttributeReadable attributeReadable : attributesChange) {
                String change = (String)attributeReadable.getValue();
                transArtifact.setChangeType(change);
            }
        }
        if ((attributesCreatedBy = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CreatedBy)) != null && attributesCreatedBy.size() > 0) {
            for (AttributeReadable attributeReadable : attributesCreatedBy) {
                String createdBy = (String)attributeReadable.getValue();
                transArtifact.setCreatedBy(createdBy);
            }
        }
        if ((attributesRank = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.Rank)) != null && attributesRank.size() > 0) {
            for (AttributeReadable attributeReadable : attributesRank) {
                String rank = (String)attributeReadable.getValue();
                transArtifact.setRank(rank);
            }
        }
        if ((attributesCreatedDate = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CreatedDate)) != null && attributesCreatedDate.size() > 0) {
            for (AttributeReadable attributeReadable : attributesCreatedDate) {
                CustomizedTeamWorkFlowArtifactLoader.fillCreatedDate(attributeReadable.getValue().toString(), transArtifact);
            }
        }
        if ((attributesStory = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.PointsAttributeType)) != null && attributesStory.size() > 0) {
            for (AttributeReadable attributeReadable : attributesStory) {
                String story = (String)attributeReadable.getValue();
                transArtifact.setStory(story);
            }
        }
        if ((attributeEstimateComp = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.EstimatedCompletionDate)) != null && attributeEstimateComp.size() > 0) {
            for (AttributeReadable attributeReadable : attributeEstimateComp) {
                if (attributeReadable.getValue() == null) continue;
                CustomizedTeamWorkFlowArtifactLoader.fillEstimatedCompletionDate(attributeReadable.getValue().toString(), transArtifact);
            }
        }
        if ((attributesCompletionDate = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CompletedDate)) != null && attributesCompletionDate.size() > 0) {
            for (AttributeReadable attributeReadable : attributesCompletionDate) {
                CustomizedTeamWorkFlowArtifactLoader.fillCompletionDate(attributeReadable.getValue().toString(), transArtifact);
            }
        }
        if ((attributesEstimatedHours = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.EstimatedHours)) != null && attributesEstimatedHours.size() > 0) {
            for (AttributeReadable attributeReadable : attributesEstimatedHours) {
                double estimatedHours = (Double)attributeReadable.getValue();
                transArtifact.setEstimatedHours(String.valueOf(estimatedHours));
            }
        }
        if ((attributesRemainingHours = readable.getAttributes((AttributeTypeToken)AtsAttributeTypes.Category1)) != null && attributesRemainingHours.size() > 0) {
            for (AttributeReadable attributeReadable : attributesRemainingHours) {
                String des = (String)attributeReadable.getValue();
                transArtifact.setRemainingHours(des);
            }
        }
    }

    private static void fillEstimatedCompletionDate(String string, CustomizedTeamWorkFlowArtifact transArtifact) {
        Date expDate = null;
        if (string.length() > 0) {
            try {
                expDate = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).parse(string);
                transArtifact.setExpectedDate(expDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private static void fillCompletionDate(String string, CustomizedTeamWorkFlowArtifact transArtifact) {
        Date compDate = null;
        if (string.length() > 0) {
            try {
                compDate = new SimpleDateFormat("E MMM dd hh:mm:ss zzz yyyy", Locale.getDefault()).parse(string);
                transArtifact.setCompletionDate(compDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public static void fillCreatedDate(String string, CustomizedTeamWorkFlowArtifact transArtifact) {
        Date createdDate = null;
        if (string.length() > 0) {
            try {
                createdDate = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).parse(string);
                transArtifact.setCreatedDate(createdDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private static void fillTeamMembersTeamLeads(ArtifactReadable teamArtifact, CustomizedTeamWorkFlowArtifact transArtifact) {
        ArrayList<String> l;
        ResultSet attributes;
        TransferableArtifact ar;
        List<ArtifactReadable> relatedArtifacts = CommonUtil.getRelatedArtifact(teamArtifact, "TeamLead");
        List<ArtifactReadable> relatedArtifacts2 = CommonUtil.getRelatedArtifact(teamArtifact, "TeamMember");
        for (ArtifactReadable artifactReadable2 : relatedArtifacts) {
            ArtifactReadable removeArt = null;
            String userId = artifactReadable2.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserId);
            for (ArtifactReadable artifactReadable3 : relatedArtifacts2) {
                String UserIdTmp = artifactReadable3.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserId);
                if (!UserIdTmp.equals(userId)) continue;
                removeArt = artifactReadable3;
                break;
            }
            if (removeArt == null) continue;
            relatedArtifacts2.remove(removeArt);
        }
        for (ArtifactReadable art : relatedArtifacts2) {
            ar = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(art, (ITransferableArtifact)ar);
            attributes = art.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId);
            for (AttributeReadable attributeReadable : attributes) {
                l = new ArrayList<String>();
                l.add(attributeReadable.getValue().toString());
                ar.putAttributes(CoreAttributeTypes.UserId.toString(), l);
            }
            transArtifact.getListTeamMembersTeamLeads().add(ar);
        }
        for (ArtifactReadable art : relatedArtifacts) {
            ar = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(art, (ITransferableArtifact)ar);
            attributes = art.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId);
            for (AttributeReadable attributeReadable : attributes) {
                l = new ArrayList();
                l.add(attributeReadable.getValue().toString());
                ar.putAttributes(CoreAttributeTypes.UserId.toString(), l);
            }
            transArtifact.getListTeamMembersTeamLeads().add(ar);
        }
    }

    public static void fillRelations(ResultSet<ArtifactReadable> relatedArtifacts, RelationTypeSide side, RelationTypeToken iRelationType, CustomizedTeamWorkFlowArtifact ar) throws OseeCoreException {
        ArrayList<TransferableArtifact> list1 = new ArrayList<TransferableArtifact>();
        for (ArtifactReadable artifactReadable : relatedArtifacts) {
            TransferableArtifact art;
            ArtifactReadable user;
            if (artifactReadable.getArtifactType().equals(AtsArtifactTypes.Version)) {
                user = (ArtifactReadable)OseeCoreData.getOrcsApi().getQueryFactory().fromBranch((BranchId)artifactReadable.getBranch()).andGuid(artifactReadable.getGuid()).getResults().getExactlyOne();
                art = new TransferableArtifact();
                TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifactDup(user, art);
                list1.add(art);
                continue;
            }
            user = (ArtifactReadable)OseeCoreData.getOrcsApi().getQueryFactory().fromBranch((BranchId)artifactReadable.getBranch()).andGuid(artifactReadable.getGuid()).getResults().getExactlyOne();
            art = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(user, (ITransferableArtifact)art);
            list1.add(art);
        }
        ar.putRelations(String.valueOf(iRelationType.getName()) + "##" + side.getSide().name(), list1);
    }
}

