/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.util.List;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.define.api.DefineApi;
import org.eclipse.osee.define.api.GitEndpoint;
import org.eclipse.osee.define.api.GitOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.orcs.OrcsApi;

public class GitEndpointImpl
implements GitEndpoint {
    private final OrcsApi orcsApi;
    private final GitOperations gitOps;
    private final ActivityLog activityLog;

    public GitEndpointImpl(ActivityLog activityLog, OrcsApi orcsApi, DefineApi defineApi) {
        this.orcsApi = orcsApi;
        this.activityLog = activityLog;
        this.gitOps = defineApi.gitOperations();
    }

    public ArtifactId trackGitBranch(BranchId branch, UserId account, String gitBranchName, boolean clone, String gitRepoUrl) {
        return this.gitOps.trackGitBranch(gitRepoUrl, branch, account, gitBranchName, clone, null);
    }

    public ArtifactId updateGitTrackingBranch(BranchId branch, String repositoryName, UserId account, boolean fetch, String gitBranchName) {
        return this.gitOps.updateGitTrackingBranch(branch, this.gitOps.getRepoArtifact(branch, repositoryName), account, gitBranchName, fetch, null, false);
    }

    public List<String> getChangeIdBetweenTags(BranchId branch, String repositoryName, String startTag, String endTag) {
        return this.gitOps.getChangeIdBetweenTags(branch, this.gitOps.getRepoArtifact(branch, repositoryName), startTag, endTag);
    }
}

