/*********************************************************************
 * Copyright (c) 2019 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.framework.core.enums.SqlTable;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedRecursive;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

/**
 * @author Ryan D. Brooks
 */
public class RelatedRecursiveHandler extends SqlHandler<CriteriaRelatedRecursive> {
   private CriteriaRelatedRecursive criteria;
   private String cteAlias;
   private String artAlias;

   @Override
   public void writeCommonTableExpression(AbstractSqlWriter writer) {
      cteAlias = writer.startRecursiveCommonTableExpression("recurse", "(id, child_level)");

      writer.write("SELECT b_art_id, 1 FROM osee_relation_link rel, osee_txs txs WHERE ");
      writer.writeEqualsParameterAnd("a_art_id", criteria.getStartArtifact());
      writer.writeEqualsParameterAnd("rel_link_type_id", criteria.getType());
      writer.write("rel.gamma_id = txs.gamma_id AND ");
      writer.writeTxBranchFilter("txs");
      writer.writeCteRecursiveUnion();
      writer.write(" SELECT b_art_id, child_level + 1 FROM " + cteAlias);
      writer.write(", osee_relation_link rel, osee_txs txs");
      writer.write(" WHERE a_art_id = id AND rel_link_type_id = ? AND rel.gamma_id = txs.gamma_id AND ");
      writer.addParameter(criteria.getType());
      writer.writeTxBranchFilter("txs");
   }

   @Override
   public void setData(CriteriaRelatedRecursive criteria) {
      this.criteria = criteria;
   }

   @Override
   public void addTables(AbstractSqlWriter writer) {
      writer.addTable(cteAlias);
      artAlias = writer.getMainTableAlias(SqlTable.ARTIFACT_TABLE);
   }

   @Override
   public void addPredicates(AbstractSqlWriter writer) {
      writer.writeEquals(cteAlias, "id", artAlias, "art_id");
   }

   @Override
   public int getPriority() {
      return SqlHandlerPriority.ARTIFACT_ID.ordinal();
   }
}