/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.task.AtsTaskEndpointApi;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.JaxAtsTasks;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.task.CreateTasksOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class AtsTaskEndpointImpl
implements AtsTaskEndpointApi {
    private final AtsApi atsApi;

    public AtsTaskEndpointImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="chgRpt")
    public ChangeReportTaskData create(ChangeReportTaskData changeReportTaskData) {
        return this.atsApi.getTaskService().createTasks(changeReportTaskData);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JaxAtsTasks create(NewTaskDatas newTaskDatas) {
        JaxAtsTasks tasks;
        CreateTasksOperation operation = new CreateTasksOperation(newTaskDatas, this.atsApi, new XResultData());
        XResultData results = operation.validate();
        if (results.isErrors()) {
            tasks = new JaxAtsTasks();
            tasks.setResults(results);
        }
        operation.run();
        tasks = new JaxAtsTasks();
        tasks.getTasks().addAll(operation.getTasks());
        return tasks;
    }

    @GET
    @Path(value="{taskId}")
    @Produces(value={"application/json"})
    public JaxAtsTask get(@PathParam(value="taskId") long taskId) {
        IAtsWorkItem task = (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).isOfType(new WorkItemType[]{WorkItemType.Task}).andIds(new Long[]{taskId}).getResults().getOneOrDefault((Object)IAtsWorkItem.SENTINEL);
        if (task.getId().equals(IAtsWorkItem.SENTINEL.getId())) {
            throw new OseeArgumentException("No Task found with id %d", new Object[]{taskId});
        }
        JaxAtsTask jaxAtsTask = CreateTasksOperation.createNewJaxTask((Long)task.getId(), (AtsApi)this.atsApi);
        return jaxAtsTask;
    }

    @DELETE
    @Path(value="{taskId}")
    public void delete(@PathParam(value="taskId") long taskId) {
        IAtsWorkItem task = (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).isOfType(new WorkItemType[]{WorkItemType.Task}).andIds(new Long[]{taskId}).getResults().getOneOrDefault((Object)IAtsWorkItem.SENTINEL);
        if (task.isValid()) {
            IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Delete Task", AtsCoreUsers.SYSTEM_USER);
            changes.deleteArtifact(task);
            changes.execute();
        }
    }
}

