/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.client.internal.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.orcs.rest.client.internal.search.PredicateFactory;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;

public class PredicateFactoryImpl
implements PredicateFactory {
    private final List<String> emptyStringList = Collections.emptyList();

    @Override
    public Predicate createGuidSearch(List<String> ids) {
        return this.createSearch(SearchMethod.GUIDS, ids);
    }

    @Override
    public Predicate createArtifactIdsSearch(Collection<? extends ArtifactId> ids) {
        LinkedList<String> strIds = new LinkedList<String>();
        for (ArtifactId artifactId : ids) {
            strIds.add(artifactId.getIdString());
        }
        return this.createSearch(SearchMethod.IDS, strIds);
    }

    private Predicate createSearch(SearchMethod method, List<String> ids) {
        return new Predicate(method, this.emptyStringList, ids, new QueryOption[0]);
    }

    @Override
    public Predicate createIsOfTypeSearch(Collection<? extends ArtifactTypeId> artifactType) {
        List<String> typeIds = this.getLongIds(artifactType);
        return new Predicate(SearchMethod.IS_OF_TYPE, this.emptyStringList, typeIds, new QueryOption[0]);
    }

    @Override
    public Predicate createTypeEqualsSearch(Collection<? extends ArtifactTypeId> artifactType) {
        List<String> typeIds = this.getLongIds(artifactType);
        return new Predicate(SearchMethod.TYPE_EQUALS, this.emptyStringList, typeIds, new QueryOption[0]);
    }

    @Override
    public Predicate createAttributeTypeSearch(Collection<? extends AttributeTypeId> attributeTypes, String value, QueryOption ... options) {
        return this.createAttributeTypeSearch(attributeTypes, Collections.singleton(value), options);
    }

    @Override
    public Predicate createAttributeTypeSearch(Collection<? extends AttributeTypeId> attributeTypes, Collection<String> values, QueryOption ... options) {
        List<String> typeIds = this.getLongIds(attributeTypes);
        return new Predicate(SearchMethod.ATTRIBUTE_TYPE, typeIds, new LinkedList<String>(values), options);
    }

    @Override
    public Predicate createAttributeExistsSearch(Collection<? extends AttributeTypeId> attributeTypes) {
        List<String> typeIds = this.getLongIds(attributeTypes);
        return new Predicate(SearchMethod.EXISTS_TYPE, Arrays.asList("attrType"), typeIds, new QueryOption[0]);
    }

    @Override
    public Predicate createAttributeNotExistsSearch(Collection<? extends AttributeTypeId> attributeTypes) {
        List<String> typeIds = this.getLongIds(attributeTypes);
        return new Predicate(SearchMethod.NOT_EXISTS_TYPE, Arrays.asList("attrType"), typeIds, new QueryOption[0]);
    }

    @Override
    public Predicate createRelationExistsSearch(Collection<? extends RelationTypeToken> relationTypes) {
        List<String> typeIds = this.getLongIds(relationTypes);
        return new Predicate(SearchMethod.EXISTS_TYPE, Arrays.asList("relType"), typeIds, new QueryOption[0]);
    }

    @Override
    public Predicate createRelationTypeSideExistsSearch(RelationTypeSide relationTypeSide) {
        String side = relationTypeSide.getSide().isSideA() ? "A" : "B";
        return new Predicate(SearchMethod.EXISTS_TYPE, Arrays.asList("relTypeSide", side), this.getLongIds((Id)relationTypeSide), new QueryOption[0]);
    }

    @Override
    public Predicate createRelationTypeSideNotExistsSearch(RelationTypeSide relationTypeSide) {
        String side = relationTypeSide.getSide().isSideA() ? "A" : "B";
        return new Predicate(SearchMethod.NOT_EXISTS_TYPE, Arrays.asList("relTypeSide", side), this.getLongIds((Id)relationTypeSide), new QueryOption[0]);
    }

    @Override
    public Predicate createRelationNotExistsSearch(Collection<? extends RelationTypeToken> relationTypes) {
        List<String> typeIds = this.getLongIds(relationTypes);
        return new Predicate(SearchMethod.NOT_EXISTS_TYPE, Arrays.asList("relType"), typeIds, new QueryOption[0]);
    }

    @Override
    public Predicate createRelatedToSearch(RelationTypeSide relationTypeSide, Collection<ArtifactId> ids) {
        LinkedList<String> values = new LinkedList<String>();
        String side = relationTypeSide.getSide().isSideA() ? "A" : "B";
        for (ArtifactId id : ids) {
            values.add(id.getIdString());
        }
        return new Predicate(SearchMethod.RELATED_TO, Arrays.asList(String.valueOf(side) + relationTypeSide.getIdString()), values, new QueryOption[0]);
    }

    private List<String> getLongIds(Collection<? extends Id> types) {
        LinkedList<String> toReturn = new LinkedList<String>();
        for (Id id : types) {
            toReturn.add(id.getIdString());
        }
        return toReturn;
    }

    private List<String> getLongIds(Id type) {
        return this.getLongIds(Collections.singletonList(type));
    }

    public static interface RestSearchOptions {
        public List<QueryOption> getOptions();
    }
}

