/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.OrcsTypesData;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.framework.resource.management.StandardOptions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.db.internal.callable.PurgeArtifactTypeDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.PurgeAttributeTypeDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.PurgeRelationTypeDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class TypesModule {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final IResourceManager resourceManager;

    public TypesModule(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory, IResourceManager resourceManager) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.resourceManager = resourceManager;
    }

    public OrcsTypesDataStore createTypesDataStore() {
        return new OrcsTypesDataStore(){

            public Callable<Void> purgeArtifactsByArtifactType(OrcsSession session, Collection<? extends ArtifactTypeToken> typesToPurge) {
                return new PurgeArtifactTypeDatabaseTxCallable(TypesModule.this.logger, session, TypesModule.this.jdbcClient, typesToPurge);
            }

            public Callable<Void> purgeAttributesByAttributeType(OrcsSession session, Collection<? extends AttributeTypeId> typesToPurge) {
                return new PurgeAttributeTypeDatabaseTxCallable(TypesModule.this.logger, session, TypesModule.this.jdbcClient, TypesModule.this.joinFactory, typesToPurge);
            }

            public Callable<Void> purgeRelationsByRelationType(OrcsSession session, Collection<? extends RelationTypeToken> typesToPurge) {
                return new PurgeRelationTypeDatabaseTxCallable(TypesModule.this.logger, session, TypesModule.this.jdbcClient, typesToPurge);
            }

            public InputStream getAccessInputStream() {
                ArrayList<String> uriPaths = new ArrayList<String>();
                TypesModule.this.jdbcClient.runQuery(stmt -> {
                    boolean bl = uriPaths.add(stmt.getString("uri"));
                }, "select uri, attr.attr_id from osee_tuple2 t2, osee_txs txs1, osee_attribute attr, osee_txs txs2 where tuple_type = ? and t2.gamma_id = txs1.gamma_id and txs1.branch_id = ? and txs1.tx_current = ? and e1 = ? and e2 = attr.attr_id and attr.gamma_id = txs2.gamma_id and txs2.branch_id = txs1.branch_id and txs2.tx_current = ?", new Object[]{CoreTupleTypes.OseeTypeDef, CoreBranches.COMMON, TxCurrent.CURRENT, OrcsTypesData.OSEE_TYPE_VERSION, TxCurrent.CURRENT});
                return this.asInputStream(uriPaths);
            }

            private InputStream asInputStream(List<String> resources) {
                PropertyStore options = new PropertyStore();
                options.put(StandardOptions.DecompressOnAquire.name(), "true");
                StringBuilder builder = new StringBuilder();
                for (String path : resources) {
                    IResourceLocator locator = TypesModule.this.resourceManager.getResourceLocator(path);
                    IResource resource = TypesModule.this.resourceManager.acquire(locator, options);
                    if (resource == null) {
                        throw new OseeStateException("Types resource can not be null for %s", new Object[]{path});
                    }
                    InputStream inputStream = null;
                    try {
                        try {
                            inputStream = resource.getContent();
                            String oseeTypeFragment = Lib.inputStreamToString((InputStream)inputStream);
                            oseeTypeFragment = oseeTypeFragment.replaceAll("import\\s+\"", "// import \"");
                            builder.append("\n//////////////     ");
                            builder.append(resource.getName());
                            builder.append("\n\n");
                            builder.append(oseeTypeFragment);
                        }
                        catch (IOException ex) {
                            OseeCoreException.wrapAndThrow((Throwable)ex);
                            Lib.close((AutoCloseable)inputStream);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        Lib.close((AutoCloseable)inputStream);
                        throw throwable;
                    }
                    Lib.close((AutoCloseable)inputStream);
                }
                InputStream toReturn = null;
                try {
                    toReturn = Lib.stringToInputStream((String)builder.toString());
                }
                catch (UnsupportedEncodingException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
                return toReturn;
            }
        };
    }
}

