/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.transaction;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.SqlTable;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.OrcsVisitor;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TransactionData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionProcessor;

public class ComodificationCheck
implements TransactionProcessor {
    private final DataLoaderFactory dataLoader;

    public ComodificationCheck(DataLoaderFactory dataLoader) {
        this.dataLoader = dataLoader;
    }

    @Override
    public void process(HasCancellation cancellation, OrcsSession session, TransactionData txData) {
        OnLoadChecker checker = new OnLoadChecker();
        cancellation.checkForCancelled();
        txData.getChangeSet().accept((OrcsVisitor)checker);
        if (!checker.getArtifactIds().isEmpty()) {
            DataLoader loader = this.dataLoader.newDataLoaderFromIds(session, txData.getBranch(), checker.getArtifactIds());
            loader.withAttributeIds(checker.getAttributeIds());
            loader.withRelationIds(checker.getRelationIds());
            loader.load(cancellation, (LoadDataHandler)checker);
        }
    }

    private final class OnLoadChecker
    extends LoadDataHandlerAdapter
    implements OrcsVisitor {
        private final Map<Integer, ArtifactData> artifacts = new HashMap<Integer, ArtifactData>();
        private final Map<Integer, AttributeData> attributes = new HashMap<Integer, AttributeData>();
        private final Map<Integer, RelationData> relations = new HashMap<Integer, RelationData>();
        private final Map<Integer, TupleData> tuples = new HashMap<Integer, TupleData>();

        private OnLoadChecker() {
        }

        public Collection<Integer> getArtifactIds() {
            return this.artifacts.keySet();
        }

        public Collection<Integer> getAttributeIds() {
            return this.attributes.keySet();
        }

        public Collection<Integer> getRelationIds() {
            return this.relations.keySet();
        }

        private void checkCoModified(OrcsData was, OrcsData is) {
            if (was != null && is != null && was.getVersion().getTransactionId().notEqual((Id)is.getVersion().getTransactionId())) {
                throw new OseeStateException("Comodification error", new Object[0]);
            }
        }

        public void visit(ArtifactData data) {
            if (data.getVersion().isInStorage()) {
                this.artifacts.put(data.getLocalId(), data);
            }
        }

        public <T> void visit(AttributeData<T> data) {
            if (data.getVersion().isInStorage()) {
                this.attributes.put(data.getLocalId(), data);
            }
        }

        public void visit(RelationData data) {
            if (data.getVersion().isInStorage()) {
                this.relations.put(data.getLocalId(), data);
            }
        }

        public void visit(TupleData data) {
            this.tuples.put(data.getLocalId(), data);
        }

        public void onData(ArtifactData data) {
            ArtifactData modified = this.artifacts.get(data.getLocalId());
            this.checkCoModified((OrcsData)data, (OrcsData)modified);
        }

        public void onData(RelationData data) {
            RelationData modified = this.relations.get(data.getLocalId());
            this.checkCoModified((OrcsData)data, (OrcsData)modified);
        }

        public <T> void onData(AttributeData<T> data) {
            AttributeData modified = this.attributes.get(data.getLocalId());
            this.checkCoModified((OrcsData)data, (OrcsData)modified);
        }

        public void deleteTuple(BranchId branch, SqlTable tupleTable, GammaId gammaId) {
        }
    }
}

