/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.search.QueryFactory;

public class LoadArtifactHistory
extends AbstractDatastoreTxCallable<List<ChangeItem>> {
    private final ArtifactId artifact;
    private final BranchId branch;
    private final OrcsTokenService tokenService;
    private final HashMap<Long, ApplicabilityToken> applicTokens;
    private static final String query = "WITH %s branches (branch_id, PARENT_BRANCH_ID, baseline_transaction_id) AS (\nSELECT child.branch_id, child.parent_branch_id, child.BASELINE_TRANSACTION_ID\nFROM osee_branch child\nWHERE child.branch_ID = ?\nUNION ALL\nSELECT parent.branch_id, parent.parent_branch_id, parent.baseline_transaction_id\nFROM osee_branch parent\nJOIN branches ON parent.branch_id = branches.parent_branch_id)\nSELECT transaction_id, b.parent_branch_id AS branch_id, 1 as table_type, art_type_id as item_type_id, art_id as item_id, 0 as item_first, 0 as item_second, 'na' as item_value, 'na' AS item_uri, item.gamma_id, mod_type, app_id\nFROM osee_artifact item, osee_txs txs , branches b\nWHERE txs.gamma_id = item.gamma_id AND item.ART_ID = ? AND txs.branch_id = b.parent_branch_id AND txs.TRANSACTION_ID < b.baseline_transaction_id\nUNION ALL\nSELECT transaction_id, b.branch_id AS branch_id, 1 as table_type, art_type_id as item_type_id, art_id as item_id, 0 as item_first, 0 as item_second, 'na' as item_value, 'na' AS item_uri, item.gamma_id, mod_type, app_id\nFROM osee_artifact item, osee_txs txs , branches b\nWHERE txs.gamma_id = item.gamma_id AND item.ART_ID = ? AND txs.BRANCH_ID = ? AND txs.branch_id = b.branch_id\nUNION ALL\nSELECT transaction_id, b.parent_branch_id AS branch_id, 2 as table_type, attr_type_id as item_type_id, attr_id as item_id, art_id as item_first, 0 as item_second, value as item_value, uri AS item_uri, item.gamma_id, mod_type, app_id\nFROM osee_attribute item, osee_txs txs, branches b\nWHERE txs.gamma_id = item.gamma_id AND item.ART_ID = ? AND txs.branch_id = b.parent_branch_id AND txs.TRANSACTION_ID < b.baseline_transaction_id\nUNION ALL \nSELECT transaction_id, b.branch_id AS branch_id, 2 as table_type, attr_type_id as item_type_id, attr_id as item_id, art_id as item_first, 0 as item_second, value as item_value, uri AS item_uri, item.gamma_id, mod_type, app_id\nFROM osee_attribute item, osee_txs txs, branches b\nWHERE txs.gamma_id = item.gamma_id AND item.ART_ID = ? AND txs.BRANCH_ID = ? AND txs.branch_id = b.branch_id\nUNION ALL\nSELECT transaction_id, b.parent_branch_id AS branch_id, 3 as table_type, rel_link_type_id as item_type_id, rel_link_id as item_id, a_art_id as item_first, b_art_id as item_second, rationale as item_value, 'na' AS item_uri, item.gamma_id, mod_type, app_id\nFROM osee_relation_link item, osee_txs txs , branches b\nWHERE txs.gamma_id = item.gamma_id AND item.a_art_id = ? AND txs.branch_id = b.parent_branch_id AND txs.TRANSACTION_ID < b.baseline_transaction_id\nUNION ALL\nSELECT transaction_id, b.branch_id AS branch_id, 3 as table_type, rel_link_type_id as item_type_id, rel_link_id as item_id, a_art_id as item_first, b_art_id as item_second, rationale as item_value, 'na' AS item_uri, item.gamma_id, mod_type, app_id\nFROM osee_relation_link item, osee_txs txs , branches b\nWHERE txs.gamma_id = item.gamma_id AND item.a_art_id = ? AND txs.BRANCH_ID = ? AND txs.branch_id = b.branch_id\nUNION ALL\nSELECT transaction_id, b.parent_branch_id AS branch_id, 3 as table_type, rel_link_type_id as item_type_id, rel_link_id as item_id, a_art_id as item_first, b_art_id as item_second, rationale as item_value, 'na' AS item_uri, item.gamma_id, mod_type, app_id\nFROM osee_relation_link item, osee_txs txs , branches b\nWHERE txs.gamma_id = item.gamma_id AND item.b_art_id = ? AND txs.branch_id = b.parent_branch_id AND txs.TRANSACTION_ID < b.baseline_transaction_id\nUNION ALL\nSELECT transaction_id, b.branch_id AS branch_id, 3 as table_type, rel_link_type_id as item_type_id, rel_link_id as item_id, a_art_id as item_first, b_art_id as item_second, rationale as item_value, 'na' AS item_uri, item.gamma_id, mod_type, app_id\nFROM osee_relation_link item, osee_txs txs , branches b\nWHERE txs.gamma_id = item.gamma_id AND item.b_art_id = ? AND txs.BRANCH_ID = ? AND txs.branch_id = b.branch_id\nORDER BY TRANSACTION_ID, table_type, item_type_id, mod_type";

    public LoadArtifactHistory(Log logger, OrcsSession session, QueryFactory queryFactory, OrcsTokenService tokenService, JdbcClient jdbcClient, ArtifactId artifact, BranchId branch) {
        super(logger, session, jdbcClient);
        this.artifact = artifact;
        this.branch = branch;
        this.tokenService = tokenService;
        this.applicTokens = queryFactory.applicabilityQuery().getApplicabilityTokens(branch);
    }

    @Override
    protected List<ChangeItem> handleTxWork(JdbcConnection connection) {
        CompositeKeyHashMap lastVersionMap = new CompositeKeyHashMap();
        LinkedList<ChangeItem> changeItems = new LinkedList<ChangeItem>();
        Consumer<JdbcStatement> consumer = stmt -> {
            TransactionId txId = TransactionId.valueOf((Long)stmt.getLong("transaction_id"));
            BranchId branchId = BranchId.valueOf((Long)stmt.getLong("branch_id"));
            TransactionToken txToken = TransactionToken.valueOf((TransactionId)txId, (BranchId)branchId);
            int tableType = stmt.getInt("table_type");
            Long itemTypeId = stmt.getLong("item_type_id");
            Long itemId = stmt.getLong("item_id");
            Long itemFirst = stmt.getLong("item_first");
            Long itemSecond = stmt.getLong("item_second");
            String value = stmt.getString("item_value");
            String uri = stmt.getString("item_uri");
            GammaId gammaId = GammaId.valueOf((Long)stmt.getLong("gamma_id"));
            ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
            ApplicabilityId appId = ApplicabilityId.valueOf((Long)stmt.getLong("app_id"));
            ApplicabilityToken applicToken = this.getApplicabilityToken(appId);
            switch (tableType) {
                case 1: {
                    ArtifactId artifactId = ArtifactId.valueOf((Long)itemId);
                    ArtifactTypeToken artTypeId = this.tokenService.getArtifactType(itemTypeId);
                    ChangeItem artChange = ChangeItemUtil.newArtifactChange((ArtifactId)artifactId, (ArtifactTypeId)artTypeId, (GammaId)gammaId, (ModificationType)modType, (ApplicabilityToken)applicToken);
                    ChangeVersion currentVersion = artChange.getCurrentVersion();
                    currentVersion.setTransactionToken(txToken);
                    currentVersion.setUri(uri);
                    ChangeVersion lastVersion = (ChangeVersion)lastVersionMap.get((Object)artifactId.getId(), (Object)branchId.getId());
                    if (lastVersion != null) {
                        artChange.setBaselineVersion(lastVersion);
                        if (modType.equals(ModificationType.NEW)) {
                            currentVersion.setModType(ModificationType.MODIFIED);
                        }
                    }
                    lastVersionMap.put((Object)artifactId.getId(), (Object)branchId.getId(), (Object)currentVersion);
                    changeItems.add(artChange);
                    break;
                }
                case 2: {
                    AttributeId attrId = AttributeId.valueOf((Long)itemId);
                    AttributeTypeGeneric attrTypeId = this.tokenService.getAttributeType(itemTypeId);
                    ArtifactId artifactId = ArtifactId.valueOf((Long)itemFirst);
                    ChangeItem attrChange = ChangeItemUtil.newAttributeChange((AttributeId)attrId, (AttributeTypeId)attrTypeId, (ArtifactId)artifactId, (GammaId)gammaId, (ModificationType)modType, (String)value, (ApplicabilityToken)applicToken);
                    ChangeVersion currentVersion = attrChange.getCurrentVersion();
                    currentVersion.setTransactionToken(txToken);
                    currentVersion.setUri(uri);
                    ChangeVersion lastVersion = (ChangeVersion)lastVersionMap.get((Object)itemId, (Object)branchId.getId());
                    if (lastVersion != null) {
                        attrChange.setBaselineVersion(lastVersion);
                    } else {
                        if (modType.isDeleted()) break;
                        currentVersion.setModType(ModificationType.NEW);
                    }
                    lastVersionMap.put((Object)itemId, (Object)branchId.getId(), (Object)currentVersion);
                    changeItems.add(attrChange);
                    break;
                }
                case 3: {
                    RelationId relId = RelationId.valueOf((Long)itemId);
                    RelationTypeToken relTypeToken = this.tokenService.getRelationType(itemTypeId);
                    ArtifactId artifactIdA = ArtifactId.valueOf((Long)itemFirst);
                    ArtifactId artifactIdB = ArtifactId.valueOf((Long)itemSecond);
                    ChangeItem relationChange = ChangeItemUtil.newRelationChange((RelationId)relId, (RelationTypeToken)relTypeToken, (GammaId)gammaId, (ModificationType)modType, (ArtifactId)artifactIdA, (ArtifactId)artifactIdB, (String)value, (ApplicabilityToken)applicToken);
                    ChangeVersion currentVersion = relationChange.getCurrentVersion();
                    currentVersion.setTransactionToken(txToken);
                    ChangeVersion lastVersion = (ChangeVersion)lastVersionMap.get((Object)relId.getId(), (Object)branchId.getId());
                    if (lastVersion == null && modType.isDeleted()) break;
                    if (lastVersion == null) {
                        currentVersion.setModType(ModificationType.NEW);
                    }
                    lastVersionMap.put((Object)relId.getId(), (Object)branchId.getId(), (Object)currentVersion);
                    changeItems.add(relationChange);
                }
            }
        };
        String query = String.format(query, this.getJdbcClient().getDbType().getRecursiveWithSql());
        this.getJdbcClient().runQuery(consumer, 10000, query, new Object[]{this.branch, this.artifact, this.artifact, this.branch, this.artifact, this.artifact, this.branch, this.artifact, this.artifact, this.branch, this.artifact, this.artifact, this.branch});
        return changeItems;
    }

    private ApplicabilityToken getApplicabilityToken(ApplicabilityId appId) {
        ApplicabilityToken toReturn = this.applicTokens.get(appId.getId());
        if (toReturn != null) {
            return toReturn;
        }
        return ApplicabilityToken.BASE;
    }
}

