/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.eclipse.osee.framework.core.executor.ExecutionCallback;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexerCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexingTaskConsumer;
import org.eclipse.osee.orcs.search.IndexerCollector;

public class IndexingTaskConsumerImpl
implements IndexingTaskConsumer {
    private final Map<Integer, Future<?>> futureTasks = new ConcurrentHashMap();
    private final IndexerCallableFactory factory;
    private final ExecutorAdmin executorAdmin;

    public IndexingTaskConsumerImpl(ExecutorAdmin executorAdmin, IndexerCallableFactory factory) {
        this.executorAdmin = executorAdmin;
        this.factory = factory;
    }

    @Override
    public int cancelTaskId(Collection<Integer> taskIds) {
        int toReturn = 0;
        for (int item : taskIds) {
            Future<?> task = this.futureTasks.get(item);
            if (task == null || task.isDone() || task.isCancelled() || !task.cancel(true)) continue;
            ++toReturn;
        }
        return toReturn;
    }

    @Override
    public int getWorkersInQueue() {
        return this.futureTasks.size();
    }

    @Override
    public Future<?> submitTaskId(OrcsSession session, AttributeTypes types, IndexerCollector collector, final int queryId) throws Exception {
        Callable<?> callable = this.factory.createIndexerTaskCallable(session, types, collector, queryId);
        if (collector != null) {
            collector.onIndexTaskSubmit(queryId);
        }
        Future future = this.executorAdmin.schedule("indexing.consumer.executor.id", callable, new ExecutionCallback(){

            public void onCancelled() {
                this.removeFromQueue();
            }

            public void onSuccess(Object result) {
                this.removeFromQueue();
            }

            public void onFailure(Throwable throwable) {
                this.removeFromQueue();
            }

            private void removeFromQueue() {
                IndexingTaskConsumerImpl.this.futureTasks.remove(queryId);
            }
        });
        this.futureTasks.put(queryId, future);
        return future;
    }
}

