/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.ObjectType;
import org.eclipse.osee.framework.core.enums.TableEnum;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeTypeExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class AttributeTypeExistsSqlHandler
extends SqlHandler<CriteriaAttributeTypeExists> {
    private CriteriaAttributeTypeExists criteria;
    private String attrAlias;
    private String txsAlias;
    private String jIdAlias;
    private AbstractJoinQuery joinQuery;
    private String cteAlias;

    @Override
    public void setData(CriteriaAttributeTypeExists criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            this.cteAlias = writer.startCommonTableExpression("attrExt");
            writer.write("SELECT max(txs.transaction_id) as transaction_id, attr.art_id as art_id\n");
            Collection types = this.criteria.getTypes();
            if (types.size() > 1) {
                writer.write(" FROM osee_txs txs, osee_attribute attr, osee_join_id id\n");
            } else {
                writer.write(" FROM osee_txs txs, osee_attribute attr\n");
            }
            writer.write(" WHERE txs.gamma_id = attr.gamma_id");
            if (types.size() > 1) {
                IdJoinQuery joinQuery = writer.writeJoin(types);
                writer.write(" AND attr.attr_type_id = id.id AND ");
                writer.writeEqualsParameterAnd("id", "query_id", joinQuery.getQueryId());
            } else {
                writer.writeEqualsParameterAnd("att", "attr_type_id", types.iterator().next());
            }
            writer.writeTxBranchFilter("txs");
            writer.write("\n GROUP BY attr.art_id");
        }
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.cteAlias != null) {
            writer.addTable(this.cteAlias);
        }
        if (this.criteria.getTypes().size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.attrAlias = writer.addTable(TableEnum.ATTRIBUTE_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ATTRIBUTE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        Collection types = this.criteria.getTypes();
        if (types.size() > 1) {
            this.joinQuery = writer.writeJoin(types);
            writer.write(this.attrAlias);
            writer.write(".attr_type_id = ");
            writer.write(this.jIdAlias);
            writer.write(".id AND ");
            writer.write(this.jIdAlias);
            writer.write(".query_id = ?");
            writer.addParameter(this.joinQuery.getQueryId());
        } else {
            AttributeTypeId type = (AttributeTypeId)types.iterator().next();
            writer.write(this.attrAlias);
            writer.write(".attr_type_id = ?");
            writer.addParameter(type);
        }
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        if (!aliases.isEmpty()) {
            writer.writeAndLn();
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(this.attrAlias);
                writer.write(".art_id = ");
                writer.write(artAlias);
                writer.write(".art_id");
                if (index + 1 < aSize) {
                    writer.write(" AND ");
                }
                ++index;
            }
        }
        if (this.cteAlias != null) {
            writer.writeAndLn();
            writer.write(this.cteAlias);
            writer.write(".transaction_id = ");
            writer.write(this.txsAlias);
            writer.write(".transaction_id AND ");
            writer.write(this.cteAlias);
            writer.write(".art_id = ");
            writer.write(this.attrAlias);
            writer.write(".art_id");
        }
        writer.writeAndLn();
        writer.write(this.attrAlias);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias);
        writer.write(".gamma_id AND ");
        boolean includeDeletedAttributes = OptionsUtil.areDeletedAttributesIncluded((Options)writer.getOptions());
        writer.writeTxBranchFilter(this.txsAlias, includeDeletedAttributes);
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_TYPE_EXISTS.ordinal();
    }
}

