/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.osee.framework.core.enums.ObjectType;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicDataHandler;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.ResultObjectDescription;
import org.eclipse.osee.orcs.db.internal.sql.ObjectField;
import org.eclipse.osee.orcs.db.internal.sql.SqlFieldResolver;

public class DynamicObjectBuilder {
    private final Log logger;
    private final OrcsTypes orcsTypes;
    private final Options options;
    private final Stack<ObjectMap> stack = new Stack();
    private DynamicDataHandler handler;
    private Iterable<? extends DynamicData> descriptors;
    private Boolean showHidden;
    private ObjectMap rootObject;

    public DynamicObjectBuilder(Log logger, OrcsTypes orcsTypes, Options options) {
        this.logger = logger;
        this.orcsTypes = orcsTypes;
        this.options = options;
    }

    public void setHandler(DynamicDataHandler handler) {
        this.handler = handler;
    }

    private boolean showHiddenFields() {
        if (this.showHidden == null) {
            this.showHidden = OptionsUtil.showHiddenFields((Options)this.options);
        }
        return this.showHidden;
    }

    public Iterable<? extends DynamicData> getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = ((ResultObjectDescription)this.options.getObject(ResultObjectDescription.class, "result.descriptor")).getDynamicData();
        }
        return this.descriptors;
    }

    private ObjectMap pop() {
        return !this.stack.isEmpty() ? this.stack.pop() : null;
    }

    private ObjectMap peek() {
        return !this.stack.isEmpty() ? this.stack.peek() : null;
    }

    public void onDynamicObjectStart(DynamicObject data) {
        this.logger.trace("DynamicObject - start - [%s]", new Object[]{data});
        ObjectMap object = new ObjectMap();
        object.setData(data);
        this.stack.push(object);
    }

    public void onDynamicField(DynamicData data, String fieldName, Object value) {
        this.logger.trace("DynamicObject - field - [%s] - field:[%s] value:[%s]", new Object[]{data, fieldName, value});
        ObjectMap current = this.stack.peek();
        if (data.isPrimaryKey()) {
            current.addHash(value);
        }
        if (this.isTypeField(data)) {
            current.setType(value);
        }
        if (this.showHiddenFields() || !data.isHidden()) {
            current.addData(fieldName, value);
        }
    }

    private boolean isTypeField(DynamicData data) {
        ObjectField objectField = SqlFieldResolver.getObjectField(data);
        return objectField != null ? objectField.isMetaTypeField() : false;
    }

    public void onDynamicObjectEnd(DynamicObject data) {
        this.logger.trace("DynamicObject - end - [%s]", new Object[]{data});
        ObjectMap current = this.pop();
        if (current != null) {
            Long hashCode = current.getHash();
            ObjectMap parent = this.peek();
            if (parent != null) {
                parent.addData(data.getName(), current);
            }
            if (this.stack.isEmpty()) {
                if (this.rootObject != null) {
                    Long rootHash = this.rootObject.getHash();
                    if (!rootHash.equals(hashCode)) {
                        this.handler.onDynamicData(this.rootObject.asMap());
                        this.rootObject = current;
                    } else {
                        this.rootObject.merge(current);
                    }
                } else {
                    this.rootObject = current;
                }
            }
        }
    }

    public void onEnd() {
        if (this.rootObject != null) {
            this.handler.onDynamicData(this.rootObject.asMap());
        }
    }

    private static <K, V> SetMultimap<K, V> newSetMultimap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        return Multimaps.newSetMultimap((Map)map, (Supplier)new Supplier<Set<V>>(){

            public Set<V> get() {
                return Sets.newLinkedHashSet();
            }
        });
    }

    private final class ObjectMap {
        private DynamicObject descriptor;
        private Long hash = 37L;
        private final Map<String, Object> data = new LinkedHashMap<String, Object>();
        private Map<Long, ObjectMap> children;
        private Long typeId;

        private ObjectMap() {
        }

        public void addData(String key, Object value) {
            if (value instanceof ObjectMap) {
                if (this.children == null) {
                    this.children = Maps.newLinkedHashMap();
                }
                ObjectMap child = (ObjectMap)value;
                this.children.put(child.getHash(), child);
            } else {
                this.data.put(key, value);
            }
        }

        public DynamicObject getDescriptor() {
            return this.descriptor;
        }

        public void setData(DynamicObject descriptor) {
            this.descriptor = descriptor;
        }

        public void setType(Object value) {
            this.typeId = Long.parseLong(String.valueOf(value));
        }

        public Long getType() {
            return this.typeId;
        }

        public void merge(ObjectMap other) {
            this.data.putAll(other.data);
            this.typeId = other.typeId;
            if (other.hasChildren()) {
                this.mergeChildren(other.children.entrySet());
            }
        }

        private void mergeChildren(Iterable<Map.Entry<Long, ObjectMap>> otherChildren) {
            for (Map.Entry<Long, ObjectMap> otherChild : otherChildren) {
                Long key = otherChild.getKey();
                ObjectMap value = otherChild.getValue();
                ObjectMap thisChild = this.children.get(key);
                if (thisChild != null) {
                    thisChild.merge(value);
                    continue;
                }
                this.children.put(key, value);
            }
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public void addHash(Object value) {
            this.hash = this.hash * Long.parseLong(String.valueOf(value));
        }

        public Long getHash() {
            return this.hash;
        }

        public Map<String, Object> asMap() {
            if (this.hasChildren()) {
                for (Map.Entry<String, Collection<ObjectMap>> entries : this.getChildrenByName()) {
                    String key = entries.getKey();
                    Collection<ObjectMap> values = entries.getValue();
                    ObjectMap object = (ObjectMap)Iterables.getFirst(values, null);
                    ObjectType objectType = this.getObjectType(object.getDescriptor());
                    if (ObjectType.ATTRIBUTE == objectType || ObjectType.RELATION == objectType) {
                        this.data.put(key, this.groupByTypeName(objectType, values));
                        continue;
                    }
                    this.data.put(key, this.asSetMap(values));
                }
            }
            return this.data;
        }

        private Map<String, Object> groupByTypeName(ObjectType objectType, Collection<ObjectMap> values) {
            SetMultimap byTypeName = DynamicObjectBuilder.newSetMultimap();
            for (ObjectMap child : values) {
                String typeName = this.resolveTypeName(objectType, child.getType());
                byTypeName.put((Object)typeName, child.asMap());
            }
            LinkedHashMap<String, Object> toReturn = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : byTypeName.asMap().entrySet()) {
                Collection collection = (Collection)entry.getValue();
                if (collection.size() == 1) {
                    toReturn.put((String)entry.getKey(), collection.iterator().next());
                    continue;
                }
                toReturn.put((String)entry.getKey(), collection);
            }
            return toReturn;
        }

        private Iterable<Map.Entry<String, Collection<ObjectMap>>> getChildrenByName() {
            SetMultimap objectMaps = DynamicObjectBuilder.newSetMultimap();
            for (ObjectMap child : this.children.values()) {
                DynamicObject descriptor = child.getDescriptor();
                String name = descriptor.getName();
                objectMaps.put((Object)name, (Object)child);
            }
            return objectMaps.asMap().entrySet();
        }

        private Set<Map<String, Object>> asSetMap(Collection<ObjectMap> values) {
            LinkedHashSet<Map<String, Object>> toReturn = new LinkedHashSet<Map<String, Object>>();
            for (ObjectMap child : values) {
                toReturn.add(child.asMap());
            }
            return toReturn;
        }

        public ObjectType getObjectType(DynamicObject descriptor) {
            String type = (String)descriptor.getGuid();
            return ObjectField.objectType(type);
        }

        public String resolveTypeName(ObjectType parentType, Long type) {
            Named typeObject = null;
            switch (parentType) {
                case ARTIFACT: {
                    typeObject = (Named)DynamicObjectBuilder.this.orcsTypes.getArtifactTypes().get(type);
                    break;
                }
                case ATTRIBUTE: {
                    typeObject = (Named)DynamicObjectBuilder.this.orcsTypes.getAttributeTypes().get(type);
                    break;
                }
                case RELATION: {
                    typeObject = (Named)DynamicObjectBuilder.this.orcsTypes.getRelationTypes().get(type);
                    break;
                }
            }
            String typeName = typeObject != null ? typeObject.getName() : String.valueOf(type);
            return typeName;
        }

        public String toString() {
            return "ObjectMap [hash=" + this.hash + ", typeId=" + this.typeId + ", data=" + this.data + ", children=" + this.children + "]";
        }
    }
}

