/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.change;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactory;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;

public class MissingChangeItemFactoryImpl
implements MissingChangeItemFactory {
    private final DataLoaderFactory dataLoaderFactory;
    private HashMap<Long, ApplicabilityToken> applicTokensForMissingArts = null;

    public MissingChangeItemFactoryImpl(DataLoaderFactory dataModuleFactory) {
        this.dataLoaderFactory = dataModuleFactory;
    }

    @Override
    public Collection<ChangeItem> createMissingChanges(List<ChangeItem> changes, TransactionToken sourceTx, TransactionToken destTx, ApplicabilityQuery applicQuery) {
        if (changes != null && !changes.isEmpty()) {
            HashSet<ArtifactId> modifiedArtIds = new HashSet<ArtifactId>();
            LinkedListMultimap modifiedAttrIds = LinkedListMultimap.create();
            LinkedListMultimap modifiedRels = LinkedListMultimap.create();
            LinkedListMultimap modifiedTuples = LinkedListMultimap.create();
            block8: for (ChangeItem change : changes) {
                switch (change.getChangeType()) {
                    case ARTIFACT_CHANGE: {
                        if (change.isSynthetic()) continue block8;
                        modifiedArtIds.add(change.getArtId());
                        break;
                    }
                    case ATTRIBUTE_CHANGE: {
                        modifiedAttrIds.put((Object)change.getArtId(), (Object)change.getItemId());
                        break;
                    }
                    case RELATION_CHANGE: {
                        modifiedRels.put((Object)change.getArtId(), (Object)change.getItemId());
                        modifiedRels.put((Object)change.getArtId(), (Object)change.getItemId());
                        modifiedRels.put((Object)change.getArtIdB(), (Object)change.getItemId());
                        break;
                    }
                    case TUPLE_CHANGE: {
                        modifiedTuples.put((Object)0L, (Object)1L);
                        break;
                    }
                    default: {
                        throw new OseeStateException("Unknonw change type detected [%s]", new Object[]{change});
                    }
                }
            }
            HashSet<ArtifactId> allArtIds = new HashSet<ArtifactId>(modifiedArtIds);
            allArtIds.addAll(modifiedAttrIds.keySet());
            allArtIds.addAll(modifiedRels.keySet());
            Set<ArtifactId> missingArtIds = Collections.EMPTY_SET;
            try {
                missingArtIds = this.determineWhichArtifactsNotOnDestination(allArtIds, destTx);
            }
            catch (NullPointerException nullPointerException) {}
            if (!missingArtIds.isEmpty()) {
                this.applicTokensForMissingArts = applicQuery.getApplicabilityTokens(sourceTx.getBranch(), destTx.getBranch());
                return this.createMissingChangeItems(sourceTx, destTx, modifiedArtIds, (Multimap<ArtifactId, Id>)modifiedAttrIds, (Multimap<ArtifactId, Id>)modifiedRels, missingArtIds, allArtIds);
            }
        }
        return Collections.emptyList();
    }

    private ApplicabilityToken getApplicabilityToken(ApplicabilityId appId) {
        Conditions.checkNotNull((Object)appId, (String)"ApplicabilityId");
        ApplicabilityToken toReturn = ApplicabilityToken.BASE;
        if (this.applicTokensForMissingArts != null && (toReturn = this.applicTokensForMissingArts.get(appId.getId())) == null) {
            toReturn = ApplicabilityToken.BASE;
        }
        return toReturn;
    }

    private Set<ArtifactId> determineWhichArtifactsNotOnDestination(Set<ArtifactId> artIds, TransactionToken destTx) {
        DataLoader loader = this.dataLoaderFactory.newDataLoader(null, destTx.getBranch(), artIds);
        final LinkedHashSet<ArtifactId> missingArtIds = new LinkedHashSet<ArtifactId>(artIds);
        loader.includeDeletedArtifacts();
        loader.fromTransaction((TransactionId)destTx);
        loader.fromBranchView(destTx.getBranch().getViewId());
        loader.load(null, (LoadDataHandler)new LoadDataHandlerAdapter(){

            public void onData(ArtifactData data) {
                missingArtIds.remove(data);
            }
        });
        return missingArtIds;
    }

    private Collection<ChangeItem> createMissingChangeItems(TransactionToken sourceTx, TransactionToken destTx, final Set<ArtifactId> modifiedArtIds, final Multimap<ArtifactId, Id> modifiedAttrIds, final Multimap<ArtifactId, Id> modifiedRels, Set<ArtifactId> missingArtIds, Set<ArtifactId> allArtIds) {
        final LinkedHashSet<ChangeItem> toReturn = new LinkedHashSet<ChangeItem>();
        final LinkedHashSet relations = new LinkedHashSet();
        DataLoader loader = this.dataLoaderFactory.newDataLoader(null, sourceTx.getBranch(), missingArtIds);
        loader.withLoadLevel(LoadLevel.ALL);
        loader.includeDeletedArtifacts();
        loader.fromTransaction((TransactionId)sourceTx);
        loader.fromBranchView(sourceTx.getBranch().getViewId());
        loader.load(null, (LoadDataHandler)new LoadDataHandlerAdapter(){

            public void onData(ArtifactData data) {
                if (!modifiedArtIds.contains(data)) {
                    toReturn.add(MissingChangeItemFactoryImpl.this.createArtifactChangeItem(data));
                }
            }

            public void onData(RelationData data) {
                if (!modifiedRels.get((Object)data.getArtifactIdA()).contains(data) && !modifiedRels.get((Object)data.getArtifactIdB()).contains(data)) {
                    relations.add(data);
                }
            }

            public <T> void onData(AttributeData<T> data) {
                if (!modifiedAttrIds.get((Object)data.getArtifactId()).contains(data)) {
                    toReturn.add(MissingChangeItemFactoryImpl.this.createAttributeChangeItem(data));
                }
            }
        });
        if (!relations.isEmpty()) {
            LinkedListMultimap relationChangesToAdd = LinkedListMultimap.create();
            for (RelationData data : relations) {
                if (allArtIds.contains(data.getArtifactIdA())) {
                    if (allArtIds.contains(data.getArtifactIdB())) {
                        toReturn.add(this.createRelationChangeItem(data));
                        continue;
                    }
                    relationChangesToAdd.put((Object)data.getArtifactIdB(), (Object)data);
                    continue;
                }
                if (!allArtIds.contains(data.getArtifactIdB())) continue;
                relationChangesToAdd.put((Object)data.getArtifactIdA(), (Object)data);
            }
            if (!relationChangesToAdd.isEmpty()) {
                toReturn.addAll(this.createExistingRelations(destTx, (Multimap<ArtifactId, RelationData>)relationChangesToAdd));
            }
        }
        return toReturn;
    }

    private Set<ChangeItem> createExistingRelations(TransactionToken destTx, final Multimap<ArtifactId, RelationData> relationChangesToAdd) {
        final LinkedHashSet<ChangeItem> toReturn = new LinkedHashSet<ChangeItem>();
        DataLoader loader = this.dataLoaderFactory.newDataLoader(null, destTx.getBranch(), (Collection)relationChangesToAdd.keySet());
        loader.fromTransaction((TransactionId)destTx);
        loader.fromBranchView(destTx.getBranch().getViewId());
        loader.load(null, (LoadDataHandler)new LoadDataHandlerAdapter(){

            public void onData(ArtifactData data) {
                for (RelationData relData : relationChangesToAdd.get((Object)data)) {
                    toReturn.add(MissingChangeItemFactoryImpl.this.createRelationChangeItem(relData));
                }
            }
        });
        return toReturn;
    }

    private <T extends Id> ModificationType determineModType(OrcsData<T> data) {
        if (data.getModType().matches(new Id[]{ModificationType.DELETED, ModificationType.ARTIFACT_DELETED})) {
            return data.getModType();
        }
        return ModificationType.INTRODUCED;
    }

    private ChangeItem createArtifactChangeItem(ArtifactData data) {
        ApplicabilityId appId = data.getApplicabilityId();
        ChangeItem artChange = ChangeItemUtil.newArtifactChange((ArtifactId)ArtifactId.valueOf((int)data.getLocalId()), (ArtifactTypeId)((ArtifactTypeId)data.getType()), (GammaId)data.getVersion().getGammaId(), (ModificationType)this.determineModType((OrcsData)data), (ApplicabilityToken)this.getApplicabilityToken(appId));
        return artChange;
    }

    private <T> ChangeItem createAttributeChangeItem(AttributeData<T> data) {
        ApplicabilityId appId = data.getApplicabilityId();
        ChangeItem attrChange = ChangeItemUtil.newAttributeChange(data, (AttributeTypeId)((AttributeTypeId)data.getType()), (ArtifactId)data.getArtifactId(), (GammaId)data.getVersion().getGammaId(), (ModificationType)this.determineModType((OrcsData<T>)data), (String)data.getDataProxy().getDisplayableString(), (ApplicabilityToken)this.getApplicabilityToken(appId));
        attrChange.getNetChange().copy(attrChange.getCurrentVersion());
        return attrChange;
    }

    private ChangeItem createRelationChangeItem(RelationData data) {
        ApplicabilityId appId = data.getApplicabilityId();
        return ChangeItemUtil.newRelationChange((RelationId)RelationId.valueOf((long)data.getLocalId().longValue()), (RelationTypeId)((RelationTypeId)data.getType()), (GammaId)data.getVersion().getGammaId(), (ModificationType)this.determineModType((OrcsData)data), (ArtifactId)data.getArtifactIdA(), (ArtifactId)data.getArtifactIdB(), (String)data.getRationale(), (ApplicabilityToken)this.getApplicabilityToken(appId));
    }
}

