/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.rs;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsApplicationRegistry;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.rs.OAuth2ResourceServerConfig;
import org.eclipse.osee.jaxrs.server.security.JaxRsOAuth;
import org.eclipse.osee.jaxrs.server.security.JaxRsOAuthResourceServerFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OAuth2ResourceServer {
    private JaxRsApplicationRegistry registry;
    private final Set<String> registeredProviders = new HashSet<String>();
    private final AtomicBoolean wasRegistered = new AtomicBoolean();
    private volatile JaxRsOAuthResourceServerFilter filter;
    private volatile List<String> audiences;
    private volatile Bundle bundle;

    public void setJaxRsApplicationRegistry(JaxRsApplicationRegistry registry) {
        this.registry = registry;
    }

    public void start(BundleContext bundleContext, Map<String, Object> props) {
        this.bundle = bundleContext.getBundle();
        this.update(props);
    }

    public void stop() {
        if (this.wasRegistered.getAndSet(false)) {
            this.deregister(this.registry);
            this.filter = null;
        }
    }

    public void update(Map<String, Object> props) {
        OAuth2ResourceServerConfig config = OAuth2ResourceServerConfig.fromProperties(props);
        if (config.isEnabled()) {
            if (!this.wasRegistered.getAndSet(true)) {
                this.initialize(config);
                this.register(this.registry, this.bundle);
            }
            this.configure(config);
        } else {
            this.stop();
        }
    }

    private void initialize(OAuth2ResourceServerConfig config) {
        this.audiences = Collections.emptyList();
        JaxRsOAuthResourceServerFilter.Builder builder = JaxRsOAuthResourceServerFilter.newBuilder().serverKey(config.getResourceServerKey()).serverSecret(config.getResourceServerSecret()).serverUri(config.getValidationServerUri());
        this.filter = config.isCacheTokensAllowed() ? builder.build(config.getTokenCacheMaxSize(), config.getTokenCacheEvictTimeoutMillis()) : builder.build();
    }

    private void configure(OAuth2ResourceServerConfig config) {
        this.filter.setRealm(config.getRealm());
        this.filter.setAudienceIsEndpointAddress(config.isAudienceIsEndpointAddress());
        this.filter.setUseUserSubject(config.isUseUserSubject());
        this.filter.setCheckFormData(config.isFilterChecksFormDataForToken());
        this.filter.setAudiences(this.audiences);
    }

    private void register(JaxRsApplicationRegistry registry, Bundle bundle) {
        for (Object object : JaxRsOAuth.getOAuthProviders()) {
            this.addProvider(registry, bundle, OAuth2ResourceServer.qualify(object.getClass().getSimpleName()), object);
        }
        this.addProvider(registry, bundle, OAuth2ResourceServer.qualify("filter"), this.filter);
    }

    private void addProvider(JaxRsApplicationRegistry registry, Bundle bundle, String name, Object object) {
        this.registeredProviders.add(name);
        registry.registerProvider(name, bundle, object);
    }

    private void deregister(JaxRsApplicationRegistry registry) {
        for (String componentName : this.registeredProviders) {
            registry.deregisterProvider(componentName);
        }
        this.registeredProviders.clear();
    }

    private static String qualify(String name) {
        return String.format("%s.security.oauth2.client.%s", "jaxrs.server", name);
    }
}

