/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollectionsUtil {
    public static Collection<String> fromString(String string, String seperator) {
        return Arrays.asList(string.split(seperator));
    }

    public static String toString(Collection c, String start, String separator, String end) {
        Iterator i = c.iterator();
        StringBuilder myString = new StringBuilder();
        if (start != null) {
            myString.append(start);
        }
        boolean first = true;
        while (i.hasNext()) {
            if (!first) {
                myString.append(separator);
            }
            myString.append(i.next().toString());
            first = false;
        }
        if (end != null) {
            myString.append(end);
        }
        return myString.toString();
    }

    public static String toString(String separator, Object ... objects) {
        ArrayList<Object> objectsCol = new ArrayList<Object>(objects.length);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            objectsCol.add(obj);
            ++n2;
        }
        return CollectionsUtil.toString(objectsCol, null, separator, null);
    }

    public static String toString(String separator, Collection c) {
        return CollectionsUtil.toString(c, null, separator, null);
    }

    public static <T> List<T> setComplement(Collection<T> superSet, Collection<T> subList) {
        ArrayList<T> complement = new ArrayList<T>(superSet.size());
        for (T obj : superSet) {
            if (subList.contains(obj)) continue;
            complement.add(obj);
        }
        return complement;
    }

    public static <T> List<T> setIntersection(Collection<T> listA, Collection<T> listB) {
        ArrayList<T> intersection = new ArrayList<T>(listA.size());
        for (T obj : listA) {
            if (!listB.contains(obj)) continue;
            intersection.add(obj);
        }
        return intersection;
    }

    public static <T> Set<T> setUnion(Collection<T> ... lists) {
        HashSet<T> union = new HashSet<T>(lists[0].size() * 2);
        int x = 0;
        while (x < lists.length) {
            union.addAll(lists[x]);
            ++x;
        }
        return union;
    }

    public static <T> boolean isEqual(Collection<T> listA, Collection<T> listB) {
        if (listA.size() != listB.size()) {
            return false;
        }
        return listA.size() == CollectionsUtil.setIntersection(listA, listB).size();
    }

    public static <T> List<T> getAggregate(T ... objects) {
        ArrayList<T> objs = new ArrayList<T>();
        if (objects != null) {
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T obj = TArray[n2];
                objs.add(obj);
                ++n2;
            }
        }
        return objs;
    }

    public static List<Object> getAggregateTree(List<Object> items, int maxPerList) {
        if (items == null) {
            throw new IllegalArgumentException("items can not be null");
        }
        if (maxPerList < 2) {
            throw new IllegalArgumentException("maxPerList can not be less than 2");
        }
        if (items.size() > maxPerList) {
            return CollectionsUtil.recursiveAggregateTree(items, maxPerList);
        }
        return new ArrayList<Object>(items);
    }

    private static List<Object> recursiveAggregateTree(List<Object> items, int maxPerList) {
        if (items.size() > maxPerList) {
            ArrayList<Object> aggregateList = new ArrayList<Object>(maxPerList);
            ArrayList<Object> childList = null;
            for (Object item : items) {
                if (childList == null || childList.size() == maxPerList) {
                    childList = new ArrayList<Object>(maxPerList);
                    aggregateList.add(childList);
                }
                childList.add(item);
            }
            if (childList != null) {
                childList.trimToSize();
            }
            aggregateList.addAll(CollectionsUtil.recursiveAggregateTree(aggregateList, maxPerList));
            aggregateList.trimToSize();
            return aggregateList;
        }
        return items;
    }

    private static <A> List<A> cast(Class<A> clazz, Collection<? extends Object> objects, CastOption castOption) {
        ArrayList<Object> results = new ArrayList<Object>(objects.size());
        for (Object object : objects) {
            if (castOption != CastOption.ALL && (castOption != CastOption.MATCHING || !object.getClass().isAssignableFrom(clazz))) continue;
            results.add(object);
        }
        return results;
    }

    public static <A> List<A> castAll(Collection<?> objects) {
        ArrayList results = new ArrayList(objects.size());
        for (Object object : objects) {
            results.add(object);
        }
        return results;
    }

    public static <A> List<A> castAll(Class<A> clazz, Collection<? extends Object> objects) {
        return CollectionsUtil.cast(clazz, objects, CastOption.ALL);
    }

    public static <A> List<A> castMatching(Class<A> clazz, Collection<? extends Object> objects) {
        return CollectionsUtil.cast(clazz, objects, CastOption.MATCHING);
    }

    public static enum CastOption {
        MATCHING,
        ALL;

    }
}

