/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.framework.jdk.core.util.xml.SimpleNamespaceContext;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Xml {
    private static final String[] XML_CHARS = new String[]{"[&]", "[<]", "[>]", "[\"]"};
    private static final String[] XML_ESCAPES = new String[]{"&amp;", "&lt;", "&gt;", "&quot;"};
    private static final String LINEFEED = "&#10;";
    private static final String CARRIAGE_RETURN = "&#13;";
    public static final XPathFactory myXPathFactory = XPathFactory.newInstance();
    public static final XPath myXPath = myXPathFactory.newXPath();
    public static final String wordLeader1 = "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><?mso-application progid='Word.Document'?>";
    public static final String wordLeader2 = "<w:wordDocument xmlns:w='http://schemas.microsoft.com/office/word/2003/wordml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:w10='urn:schemas-microsoft-com:office:word' xmlns:sl='http://schemas.microsoft.com/schemaLibrary/2003/core' xmlns:aml='http://schemas.microsoft.com/aml/2001/core' xmlns:wx='http://schemas.microsoft.com/office/word/2003/auxHint' xmlns:o='urn:schemas-microsoft-com:office:office' xmlns:dt='uuid:C2F41010-65B3-11d1-A29F-00AA00C14882' xmlns:wsp='http://schemas.microsoft.com/office/word/2003/wordml/sp2' xmlns:ns0='http://www.w3.org/2001/XMLSchema' xmlns:ns1='http://eclipse.org/artifact.xsd' xmlns:st1='urn:schemas-microsoft-com:office:smarttags' w:macrosPresent='no' w:embeddedObjPresent='no' w:ocxPresent='no' xml:space='preserve'>";
    public static final String wordLeader = "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><?mso-application progid='Word.Document'?>".concat("<w:wordDocument xmlns:w='http://schemas.microsoft.com/office/word/2003/wordml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:w10='urn:schemas-microsoft-com:office:word' xmlns:sl='http://schemas.microsoft.com/schemaLibrary/2003/core' xmlns:aml='http://schemas.microsoft.com/aml/2001/core' xmlns:wx='http://schemas.microsoft.com/office/word/2003/auxHint' xmlns:o='urn:schemas-microsoft-com:office:office' xmlns:dt='uuid:C2F41010-65B3-11d1-A29F-00AA00C14882' xmlns:wsp='http://schemas.microsoft.com/office/word/2003/wordml/sp2' xmlns:ns0='http://www.w3.org/2001/XMLSchema' xmlns:ns1='http://eclipse.org/artifact.xsd' xmlns:st1='urn:schemas-microsoft-com:office:smarttags' w:macrosPresent='no' w:embeddedObjPresent='no' w:ocxPresent='no' xml:space='preserve'>");
    public static final String wordBody = "<w:body></w:body>";
    public static final String wordTrailer = "</w:wordDocument> ";
    public final SimpleNamespaceContext mySimpleNamespaceContext = new SimpleNamespaceContext();
    public static final Matcher theFunnyQuoteMatcher = Pattern.compile("\ufffd").matcher("");
    private static final String INVALID_XML_CHARS = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";

    public static String removeInvalidChars(String input) {
        return input.replaceAll(INVALID_XML_CHARS, "");
    }

    public static StringBuilder unescape(String text) {
        StringBuilder strB = new StringBuilder();
        int index = 0;
        while (index < text.length()) {
            char chr = text.charAt(index);
            if (chr == '&') {
                int startIndex = index;
                int endIndex = text.indexOf(59, startIndex) + 1;
                if (endIndex > startIndex && endIndex < startIndex + 6) {
                    String entityReference = text.substring(startIndex, endIndex);
                    if (entityReference.equals("&amp;")) {
                        strB.append('&');
                    } else if (entityReference.equals("&lt;")) {
                        strB.append('<');
                    } else if (entityReference.equals("&gt;")) {
                        strB.append('>');
                    } else if (entityReference.equals("&nbsp;")) {
                        strB.append(' ');
                    } else if (entityReference.equals("&quot;")) {
                        strB.append('\"');
                    } else {
                        throw new IllegalArgumentException("unknown entity reference: " + text.substring(startIndex, endIndex));
                    }
                    index = endIndex - 1;
                } else {
                    strB.append(chr);
                }
            } else {
                strB.append(chr);
            }
            ++index;
        }
        return strB;
    }

    public static CharSequence escape(CharSequence text) {
        String textString = text.toString();
        int x = 0;
        while (x < XML_CHARS.length) {
            textString = textString.replaceAll(XML_CHARS[x], XML_ESCAPES[x]);
            ++x;
        }
        textString = textString.replace("\r", "");
        textString = textString.replace("\n", "<w:br/>");
        return textString;
    }

    public static void writeWhileHandlingCdata(Appendable appendable, String string) throws IOException {
        if (string.indexOf(60) == -1 && string.indexOf(38) == -1) {
            Xml.writeData(appendable, string);
        } else {
            int cdataEnd = string.indexOf("]]>");
            if (cdataEnd != -1) {
                Xml.writeCdata(appendable, string.substring(0, cdataEnd));
                Xml.writeWhileHandlingCdata(appendable, string.substring(cdataEnd));
            } else {
                Xml.writeCdata(appendable, string);
            }
        }
    }

    private static void writeCdata(Appendable appendable, String content) throws IOException {
        appendable.append("<![CDATA[");
        appendable.append(content);
        appendable.append("]]>");
    }

    public static void writeData(Appendable appendable, String string) throws IOException {
        int index = 0;
        while (index < string.length()) {
            char value = string.charAt(index);
            if (value == '\r') {
                appendable.append(CARRIAGE_RETURN);
            } else if (value == '\n') {
                appendable.append(LINEFEED);
            } else {
                appendable.append(value);
            }
            ++index;
        }
    }

    public static String treatNonUTF8Characters(String contentString) {
        StringBuffer myStringBuffer;
        String resultString = contentString;
        String[][] nonUTF8CharactersOfInterest = new String[][]{{"\ufffd", "-"}, {"\ufffd", "'"}, {"\ufffd", "'"}, {"\ufffd", "\""}, {"\ufffd", "\""}};
        int i = 0;
        while (i < nonUTF8CharactersOfInterest.length) {
            String[] splitsOfNonUTF8 = resultString.split(nonUTF8CharactersOfInterest[i][0]);
            if (splitsOfNonUTF8.length > 1) {
                myStringBuffer = new StringBuffer();
                int j = 0;
                while (j < splitsOfNonUTF8.length) {
                    myStringBuffer.append(splitsOfNonUTF8[j]);
                    if (splitsOfNonUTF8[j].length() > 0 && j < splitsOfNonUTF8.length - 1) {
                        myStringBuffer.append(nonUTF8CharactersOfInterest[i][1]);
                    }
                    ++j;
                }
                resultString = myStringBuffer.toString();
            }
            ++i;
        }
        String[] splits = resultString.split("[^\\p{Space}\\p{Graph}]");
        int stringPosition = 0;
        if (splits.length > 1) {
            myStringBuffer = new StringBuffer();
            int i2 = 0;
            while (i2 < splits.length) {
                stringPosition += splits[i2].length();
                myStringBuffer.append(splits[i2]);
                ++stringPosition;
                if (splits[i2].length() > 0 && i2 < splits.length - 1) {
                    myStringBuffer.append("-");
                }
                ++i2;
            }
            resultString = myStringBuffer.toString();
        }
        return resultString;
    }

    public static final Element appendNewElementWithText(Node parentNode, String newElementTagName, String newText) {
        Element newElement = null;
        try {
            Document ownerDocument = parentNode.getNodeType() == 9 ? (Document)parentNode : parentNode.getOwnerDocument();
            newElement = ownerDocument.createElement(newElementTagName);
            parentNode.appendChild(newElement);
            if (newText != null) {
                Text newTextNode = ownerDocument.createTextNode(newText);
                newElement.appendChild(newTextNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newElement;
    }

    public static final Element appendNewElementWithTextCData(Node parentNode, String newElementTagName, String newText) {
        Element newElement = null;
        try {
            Document ownerDocument = parentNode.getNodeType() == 9 ? (Document)parentNode : parentNode.getOwnerDocument();
            newElement = ownerDocument.createElement(newElementTagName);
            parentNode.appendChild(newElement);
            if (newText != null) {
                CDATASection newTextNode = ownerDocument.createCDATASection(newText);
                newElement.appendChild(newTextNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newElement;
    }

    public static final Element appendNewElementWithTextAndAttributes(Node parentNode, String newElementTagName, String newText, String[][] attributes) {
        Element newElement = null;
        try {
            Document ownerDocument = parentNode.getNodeType() == 9 ? (Document)parentNode : parentNode.getOwnerDocument();
            newElement = ownerDocument.createElement(newElementTagName);
            parentNode.appendChild(newElement);
            if (newText != null) {
                Text newTextNode = ownerDocument.createTextNode(newText);
                newElement.appendChild(newTextNode);
            }
            if (attributes != null) {
                String[][] stringArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] attribute = stringArray[n2];
                    newElement.setAttribute(attribute[0], attribute[1]);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newElement;
    }

    public static final Element[] appendNewElementsWithText(Node parentNode, String newElementsTagName, String[] textInstances) {
        Element[] newElements = null;
        try {
            if (textInstances != null) {
                newElements = new Element[textInstances.length];
                Document ownerDocument = parentNode.getNodeType() == 9 ? (Document)parentNode : parentNode.getOwnerDocument();
                int i = 0;
                while (i < textInstances.length) {
                    newElements[i] = ownerDocument.createElement(newElementsTagName);
                    parentNode.appendChild(newElements[i]);
                    String textInstance = textInstances[i] == null ? "null" : textInstances[i];
                    textInstance = textInstance.length() == 0 ? "null" : textInstance;
                    newElements[i].appendChild(ownerDocument.createTextNode(textInstance));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newElements;
    }

    public static final Element appendNewElementWithTextAndOneAttribute(Node parentNode, String newElementTagName, String newText, String attributeName, String attributeValue) {
        Element newElement = null;
        try {
            newElement = Xml.appendNewElementWithText(parentNode, newElementTagName, newText);
            newElement.setAttribute(attributeName, attributeValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newElement;
    }

    public static final String restartNumberingWhenPreparingToEditWithWord(InputStream myInputStream) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, TransformerException {
        Node[] mywilfo;
        SimpleNamespaceContext mySimpleNamespaceContext = new SimpleNamespaceContext();
        Xml.addNamespacesForWordMarkupLanguage(myXPath, mySimpleNamespaceContext);
        Document myDocument = Jaxp.readXmlDocumentNamespaceAware(myInputStream);
        Element myDocumentElement = myDocument.getDocumentElement();
        Node[] myListss = Xml.selectNodeList(myDocumentElement, "descendant::w:lists");
        Node[] myLists = Xml.selectNodeList(myDocumentElement, "descendant::w:lists/w:list");
        if (myLists.length > 0 && myListss.length > 0 && (mywilfo = Xml.selectNodeList(myLists[myLists.length - 1], "@w:ilfo")).length > 0) {
            String myLastUsedListInitializeListFormat = mywilfo[0].getNodeValue();
            int myNextILFO = Integer.parseInt(myLastUsedListInitializeListFormat);
            Node[] myListDefinition = Xml.selectNodeList(myDocumentElement, "descendant::w:listDef[child::w:lvl[1]/w:pStyle/@w:val = 'listlvl1'][1]");
            if (myListDefinition.length > 0) {
                String mylistDefaultID = Xml.selectNodeList(myListDefinition[0], "@w:listDefId")[0].getNodeValue();
                Node[] myWord_Formatted_Contents = Xml.selectNodeList(myDocument, "descendant::ns1:Word_Formatted_Content");
                int i = 0;
                while (i < myWord_Formatted_Contents.length) {
                    Node[] myPStyles = Xml.selectNodeList(myWord_Formatted_Contents[i], "descendant::w:pPr[child::w:pStyle[@w:val = 'listlvl1']]");
                    int j = 0;
                    while (j < Math.min(1, myPStyles.length)) {
                        Node[] myListProperties = Xml.selectNodeList(myPStyles[j], "child::w:listPr");
                        if (myListProperties.length > 0) {
                            Element newWList = Xml.appendNewElementWithTextAndOneAttribute(myListss[0], "w:list", null, "w:ilfo", "" + ++myNextILFO);
                            Xml.appendNewElementWithTextAndOneAttribute(newWList, "w:ilst", null, "w:val", mylistDefaultID);
                            Element new_lvlOverride = Xml.appendNewElementWithTextAndOneAttribute(newWList, "w:lvlOverride", null, "w:ilvl", "0");
                            Xml.appendNewElementWithTextAndOneAttribute(new_lvlOverride, "w:startOverride", null, "w:val", "1");
                            Xml.appendNewElementWithTextAndOneAttribute(myListProperties[0], "w:ilvl", null, "w:val", "0");
                            Xml.appendNewElementWithTextAndOneAttribute(myListProperties[0], "w:ilfo", null, "w:val", "" + myNextILFO);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        String myString = Jaxp.xmlToString(myDocument, true);
        return myString;
    }

    public static Document readWordFormattedContent(String myInputString) throws IOException, ParserConfigurationException, SAXException {
        Document myDocument = null;
        myDocument = Jaxp.readXmlDocumentNamespaceAware(wordLeader.concat(myInputString).concat(wordTrailer));
        return myDocument;
    }

    public static final Object addNamespacesForWordMarkupLanguage(XPath myXPath, SimpleNamespaceContext mySimpleNamespaceContext) {
        try {
            if (myXPath.getNamespaceContext() == null) {
                mySimpleNamespaceContext.addNamespace("w", "http://schemas.microsoft.com/office/word/2003/wordml");
                mySimpleNamespaceContext.addNamespace("wx", "http://schemas.microsoft.com/office/word/2003/auxHint");
                mySimpleNamespaceContext.addNamespace("o", "urn:schemas-microsoft-com:office:office");
                mySimpleNamespaceContext.addNamespace("v", "urn:schemas-microsoft-com:vml");
                mySimpleNamespaceContext.addNamespace("aml", "http://schemas.microsoft.com/aml/2001/core");
                mySimpleNamespaceContext.addNamespace("dt", "uuid:C2F41010-65B3-11d1-A29F-00AA00C14882");
                mySimpleNamespaceContext.addNamespace("ns0", "http://www.w3.org/2001/XMLSchema");
                mySimpleNamespaceContext.addNamespace("ns1", "http://eclipse.org/artifact.xsd");
                mySimpleNamespaceContext.addNamespace("ns2", "urn:schemas-microsoft-com:office:smarttags");
                mySimpleNamespaceContext.addNamespace("sl", "http://schemas.microsoft.com/schemaLibrary/2003/core");
                mySimpleNamespaceContext.addNamespace("st0", "urn:schemas-microsoft-com:office:smarttags");
                mySimpleNamespaceContext.addNamespace("st1", "urn:schemas-microsoft-com:office:smarttags");
                mySimpleNamespaceContext.addNamespace("st2", "urn:schemas-microsoft-com:office:smarttags");
                mySimpleNamespaceContext.addNamespace("st3", "urn:schemas-microsoft-com:office:smarttags");
                mySimpleNamespaceContext.addNamespace("st4", "urn:schemas-microsoft-com:office:smarttags");
                mySimpleNamespaceContext.addNamespace("w10", "urn:schemas-microsoft-com:office:word");
                mySimpleNamespaceContext.addNamespace("wsp", "http://schemas.microsoft.com/office/word/2003/wordml/sp2");
                mySimpleNamespaceContext.addNamespace("foo", "http://apache.org/foo");
                mySimpleNamespaceContext.addNamespace("bar", "http://apache.org/bar");
                myXPath.setNamespaceContext(mySimpleNamespaceContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static final boolean isSeriousXPath(String xPathExpression) {
        return xPathExpression.indexOf("[") > -1 || xPathExpression.indexOf("]") > -1 || xPathExpression.indexOf("(") > -1 || xPathExpression.indexOf(")") > -1 || xPathExpression.indexOf(":") > -1;
    }

    public static final Node[] selectNodeList(Node startingNode, String xPathExpression) throws XPathExpressionException {
        Node[] resultNodes = null;
        if (!Xml.isSeriousXPath(xPathExpression) && startingNode.getNodeType() == 1) {
            List<Element> resultElementList = Jaxp.findElements((Element)startingNode, xPathExpression);
            resultNodes = resultElementList.toArray(new Node[0]);
        } else {
            Object publisherNodeSet = null;
            publisherNodeSet = myXPath.evaluate(xPathExpression, startingNode, XPathConstants.NODESET);
            NodeList myNodeList = (NodeList)publisherNodeSet;
            resultNodes = new Node[myNodeList.getLength()];
            int i = 0;
            while (i < resultNodes.length) {
                resultNodes[i] = myNodeList.item(i);
                ++i;
            }
        }
        return resultNodes;
    }

    public static final String selectNodesText(Node startingNode, String xPathExpression) throws XPathExpressionException {
        String resultString = null;
        if (!Xml.isSeriousXPath(xPathExpression) && startingNode.getNodeType() == 1) {
            Element foundElement = Jaxp.findElement((Element)startingNode, xPathExpression);
            if (foundElement != null) {
                resultString = Xml.selectNodesText(foundElement).trim();
            }
        } else {
            Node[] selectedNodes = Xml.selectNodeList(startingNode, xPathExpression);
            if (selectedNodes.length > 0) {
                resultString = Xml.selectNodesText(selectedNodes[0]).trim();
            }
        }
        return resultString;
    }

    public static final String selectNodesText(Node startingNode) {
        StringBuffer resultStringBuffer = new StringBuffer();
        NodeList childNodes = startingNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 4 || childNodes.item(i).getNodeType() == 3) {
                resultStringBuffer.append(childNodes.item(i).getNodeValue().trim());
            }
            ++i;
        }
        return resultStringBuffer.toString();
    }

    public static final Element makeTable(Element parentDivElement, String caption, String[][] columnDescriptors) {
        Element newTableElement = Xml.appendNewElementWithTextAndAttributes(parentDivElement, "table", null, new String[][]{{"border", "1"}, {"cellpadding", "3"}, {"cellspacing", "0"}, {"width", "100%"}});
        Xml.appendNewElementWithText(newTableElement, "caption", caption);
        Element columnGroupElement = Xml.appendNewElementWithTextAndAttributes(newTableElement, "colgroup", null, new String[][]{{"align", "left"}});
        String[] columnNames = new String[columnDescriptors.length];
        int i = 0;
        while (i < columnDescriptors.length) {
            columnNames[i] = columnDescriptors[i][0];
            Xml.appendNewElementWithTextAndAttributes(columnGroupElement, "col", null, new String[][]{{"width", columnDescriptors[i][1]}});
            ++i;
        }
        Element headingTableRowElement = Xml.appendNewElementWithText(newTableElement, "tr", null);
        Xml.appendNewElementsWithText(headingTableRowElement, "th", columnNames);
        return newTableElement;
    }

    public static final Element[] makeDivElementAndTableElement(Element parentDivElement, String caption, String[][] columnDescriptors) {
        Element[] elementArray = new Element[3];
        elementArray[0] = parentDivElement;
        elementArray[1] = parentDivElement.getOwnerDocument().createElement("div");
        Element[] divAndTableElements = elementArray;
        divAndTableElements[2] = Xml.makeTable(divAndTableElements[1], caption, columnDescriptors);
        return divAndTableElements;
    }

    public static final Element[] makeTableRow(Element[] devAndTableElements, String[] cellContents) {
        Element nextRow = Xml.appendNewElementWithText(devAndTableElements[2], "tr", null);
        Xml.appendNewElementsWithText(nextRow, "td", cellContents);
        return devAndTableElements;
    }

    public static final Element makeTableRow(Element[] devAndTableElements, String[][] cellContentsAndStyle) {
        Element nextRow = Xml.appendNewElementWithText(devAndTableElements[2], "tr", null);
        String[][] stringArray = cellContentsAndStyle;
        int n = cellContentsAndStyle.length;
        int n2 = 0;
        while (n2 < n) {
            String[] cellContentsAndStyleArray = stringArray[n2];
            if (cellContentsAndStyleArray.length > 1) {
                Xml.appendNewElementWithTextAndOneAttribute(nextRow, "td", cellContentsAndStyleArray[0], cellContentsAndStyleArray[1], cellContentsAndStyleArray[2]);
            } else {
                Xml.appendNewElementsWithText(nextRow, "td", new String[]{cellContentsAndStyleArray[0]});
            }
            ++n2;
        }
        return nextRow;
    }

    public static final Node writePrettyXML(Node aNode, File resultXmlFile) {
        try {
            Node[] notUTF8Nodes = Xml.selectNodeList(aNode, "descendant::text()[contains(.,'\ufffd')]");
            int i = 0;
            while (i < notUTF8Nodes.length) {
                notUTF8Nodes[i].setNodeValue(theFunnyQuoteMatcher.reset(notUTF8Nodes[i].getNodeValue()).replaceAll("'"));
                ++i;
            }
            Jaxp.writeXmlDocument(aNode.getOwnerDocument(), resultXmlFile, Jaxp.getPrettyFormat());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aNode;
    }
}

