/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final String AMP = "&";
    private static final String DBL_AMP = "&&";
    private static final String SPACE_COMMON = "\n|\t|\r|" + System.getProperty("line.separator");
    private static final String AND = "and";
    private static final String STR = "%s%s%s";
    private static final String QUOTE_STR = "\"";
    public static final String EMPTY_STRING = "";
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    private Strings() {
    }

    public static boolean isValid(String value) {
        return value != null && !value.isEmpty();
    }

    public static String intern(String str) {
        return str == null ? null : str.intern();
    }

    public static boolean isValid(CharSequence ... values) {
        CharSequence[] charSequenceArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence value = charSequenceArray[n2];
            if (value == null || value.length() == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String emptyString() {
        return EMPTY_STRING;
    }

    public static String escapeAmpersands(String stringWithAmp) {
        return Strings.saferReplace(stringWithAmp, AMP, DBL_AMP);
    }

    public static String minimize(String value) {
        return Strings.saferReplace(value, SPACE_COMMON, EMPTY_STRING);
    }

    public static String saferReplace(String inputStr, String target, String replacement) {
        return Strings.isValid(inputStr) ? inputStr.replaceAll(target, replacement) : inputStr;
    }

    public static String truncate(String value, int length) {
        return Strings.truncate(value, length, false);
    }

    public static String truncateEndChar(String str, int value) {
        if (Strings.isValid(str) && value == str.charAt(str.length() - 1)) {
            str = Strings.truncate(str, str.length() - 1);
        }
        return str;
    }

    public static String truncate(String value, int length, boolean ellipsis) {
        if (!Strings.isValid(value)) {
            return Strings.emptyString();
        }
        String toReturn = value;
        if (value.length() > length) {
            int len = ellipsis && length - 3 > 0 ? length - 3 : length;
            toReturn = String.valueOf(value.substring(0, Math.min(length, len))) + (ellipsis ? "..." : Strings.emptyString());
        }
        return toReturn;
    }

    public static String unquote(String nameReference) {
        return Strings.wrapWith(nameReference, QUOTE_STR, true);
    }

    public static String quote(String nameReference) {
        return Strings.wrapWith(nameReference, QUOTE_STR, false);
    }

    public static String wrapWith(String value, String surroundStr, boolean unWrap) {
        if (Strings.isValid(value)) {
            value = value.trim();
            if (unWrap) {
                if (value.startsWith(surroundStr) && value.endsWith(surroundStr) && 2 * surroundStr.length() < value.length()) {
                    value = value.substring(surroundStr.length(), value.length() - surroundStr.length());
                }
            } else {
                value = String.format(STR, surroundStr, value, surroundStr);
            }
        }
        return value;
    }

    public static String buildStatment(List<?> items) {
        return Strings.buildStatement(items, AND);
    }

    public static String buildStatement(List<?> items, String joiningWord) {
        String statement = null;
        if (items != null) {
            StringBuilder niceList = new StringBuilder();
            if (items.size() >= 2) {
                int andIndex = items.size() - 2;
                int itemIndex = 0;
                while (itemIndex < items.size()) {
                    niceList.append(items.get(itemIndex));
                    if (itemIndex == andIndex) {
                        niceList.append(' ');
                        niceList.append(joiningWord);
                        niceList.append(' ');
                    } else if (itemIndex < andIndex) {
                        niceList.append(", ");
                    }
                    ++itemIndex;
                }
            } else if (!items.isEmpty()) {
                niceList.append(items.get(0));
            }
            statement = niceList.toString();
        }
        return statement;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean isNumeric(String value) {
        boolean result = false;
        if (Strings.isValid(value)) {
            Matcher matcher = NUMERIC_PATTERN.matcher(value);
            result = matcher.matches();
        }
        return result;
    }

    public static boolean isInValid(String value) {
        return !Strings.isValid(value);
    }

    public static String xmlToText(String str) {
        String removed = str.replaceAll("<[^>]+>", EMPTY_STRING);
        removed = removed.replaceAll("&amp;", AMP);
        removed = removed.replaceAll("&lt;", "<");
        removed = removed.replaceAll("&gt;", ">");
        removed = removed.replaceAll("&quot;", QUOTE_STR);
        return removed;
    }

    public static boolean isPrintable(String str) {
        return str.equals(Strings.removeNonPrintableCharacters(str));
    }

    public static String removeNonPrintableCharacters(String str) {
        str = str.replaceAll("[^\\x00-\\x7F]", EMPTY_STRING);
        str = str.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", EMPTY_STRING);
        str = str.replaceAll("\\p{C}", EMPTY_STRING);
        return str.trim();
    }

    public static boolean isPrintable(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static String removeAllButAlphaNumeric(String str) {
        str = str.replaceAll(" ", "_");
        str = str.replaceAll("[^a-zA-Z0-9_]", EMPTY_STRING);
        return str;
    }

    public static boolean isNotNumeric(String idStr) {
        return !Strings.isNumeric(idStr);
    }
}

