/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public interface NamedId
extends Named,
Id {
    public static final NamedId SENTINEL = new NamedIdBase(-1L, "SENTINEL");
    public static final Pattern nameIdPattern = Pattern.compile("\\[(.*)\\]-\\[(.*)\\]");

    default public String toStringWithId() {
        return NamedId.toStringWithId(this);
    }

    public static NamedId getFromStringWithid(String value) {
        NamedId token = SENTINEL;
        Matcher matcher = nameIdPattern.matcher(value);
        if (matcher.find()) {
            Long id = Long.valueOf(matcher.group(2));
            token = new NamedIdBase(id, matcher.group(1));
        }
        return token;
    }

    public static String toStringWithId(NamedId namedId) {
        return String.format("[%s]-[%s]", namedId.getName(), namedId.getIdString());
    }
}

