/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client.internal.ext;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.eclipse.osee.jaxrs.client.JaxRsClient;
import org.eclipse.osee.jaxrs.client.JaxRsClientConfig;
import org.eclipse.osee.jaxrs.client.JaxRsWebTarget;
import org.eclipse.osee.jaxrs.client.internal.JaxRsClientConfigurator;
import org.eclipse.osee.jaxrs.client.internal.ext.JaxRsWebTargetImpl;

public class CxfJaxRsClientFactory
implements JaxRsClient.JaxRsClientFactory {
    private final JaxRsClientConfigurator configurator;

    public CxfJaxRsClientFactory(JaxRsClientConfigurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public JaxRsWebTarget newTarget(JaxRsClientConfig config, String serverAddress) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        this.configurator.configureClientBuilder(config, builder);
        Client client = builder.build();
        String baseAddress = serverAddress != null ? serverAddress : "";
        WebTarget target = client.target(baseAddress);
        target.request();
        this.configureConnection(config, target);
        return new JaxRsWebTargetImpl(target);
    }

    @Override
    public <T> T newClient(JaxRsClientConfig config, String serverAddress, Class<T> clazz) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        this.configurator.configureBean(config, serverAddress, bean);
        bean.setServiceClass(clazz);
        Object client = bean.create(clazz, new Object[0]);
        this.configureConnection(config, client);
        return (T)client;
    }

    private void configureConnection(JaxRsClientConfig config, Object client) {
        ClientConfiguration clientConfig = WebClient.getConfig((Object)client);
        HTTPConduit conduit = clientConfig.getHttpConduit();
        this.configurator.configureConnection(config, conduit);
        this.configurator.configureProxy(config, conduit);
    }
}

