/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client.internal.ext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.spec.ClientBuilderImpl;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.cxf.transport.common.gzip.GZIPFeature;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.JacksonFeature;
import org.eclipse.osee.jaxrs.client.JaxRsClientConfig;
import org.eclipse.osee.jaxrs.client.JaxRsClientConstants;
import org.eclipse.osee.jaxrs.client.internal.JaxRsClientConfigurator;
import org.eclipse.osee.jaxrs.client.internal.OseeAccountClientRequestFilter;
import org.eclipse.osee.jaxrs.client.internal.ext.GenericResponseExceptionMapper;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2ClientRequestFilter;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Util;
import org.eclipse.osee.jaxrs.client.internal.ext.OrcsParamConverterProvider;

public final class CxfJaxRsClientConfigurator
implements JaxRsClientConfigurator {
    private static final String JAVAX_WS_RS_CLIENT_BUILDER_PROPERTY = "javax.ws.rs.client.ClientBuilder";
    private static final String DEFAULT_JAXRS_CLIENT_BUILDER_IMPL = "org.apache.cxf.jaxrs.client.spec.ClientBuilderImpl";
    private final OAuthFactory oauthFactory;
    private List<? extends Object> providers;
    private List<Feature> features;
    private Map<String, Object> properties;

    public CxfJaxRsClientConfigurator(OAuthFactory oauthFactory) {
        this.oauthFactory = oauthFactory;
    }

    public List<? extends Object> getProviders() {
        return this.providers;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void configureJaxRsRuntime() {
        RuntimeDelegateImpl runtimeDelegate = new RuntimeDelegateImpl();
        RuntimeDelegate.setInstance((RuntimeDelegate)runtimeDelegate);
        new ClientBuilderImpl();
        System.setProperty(JAVAX_WS_RS_CLIENT_BUILDER_PROPERTY, DEFAULT_JAXRS_CLIENT_BUILDER_IMPL);
    }

    @Override
    public void configureDefaults(Map<String, Object> properties) {
        ArrayList<? extends Object> providers = new ArrayList<Object>();
        providers.add(new GenericResponseExceptionMapper());
        providers.addAll(JacksonFeature.getProviders());
        providers.addAll(OAuth2Util.getOAuthProviders());
        providers.add(new OrcsParamConverterProvider());
        providers.add(new OseeAccountClientRequestFilter());
        this.providers = providers;
        ArrayList<Feature> features = new ArrayList<Feature>(2);
        LoggingFeature loggingFeature = new LoggingFeature();
        loggingFeature.setPrettyLogging(true);
        features.add((Feature)loggingFeature);
        features.add((Feature)new GZIPFeature());
        this.features = features;
        this.properties = new LinkedHashMap<String, Object>(properties);
    }

    @Override
    public void configureBean(JaxRsClientConfig config, String serverAddress, JAXRSClientFactoryBean bean) {
        Conditions.checkNotNullOrEmpty((String)serverAddress, (String)"server address");
        bean.setAddress(serverAddress);
        bean.setProviders(this.getProviders());
        bean.setFeatures(this.getFeatures());
        bean.setProperties(this.getProperties());
        bean.setProviders(this.getOAuthProviders(config));
        boolean threadSafe = config.isCreateThreadSafeProxyClients();
        if (threadSafe) {
            bean.setInitialState((ClientState)new ThreadLocalClientState(serverAddress));
        }
        boolean inheritHeaders = config.isProxyClientSubResourcesInheritHeaders();
        bean.setInheritHeaders(inheritHeaders);
    }

    @Override
    public void configureClientBuilder(JaxRsClientConfig config, ClientBuilder builder) {
        CxfJaxRsClientConfigurator.register(builder, this.getProviders());
        CxfJaxRsClientConfigurator.register(builder, this.getFeatures());
        CxfJaxRsClientConfigurator.register(builder, this.getProperties());
        CxfJaxRsClientConfigurator.register(builder, this.getOAuthProviders(config));
    }

    @Override
    public void configureConnection(JaxRsClientConfig config, HTTPConduit conduit) {
        HTTPClientPolicy policy1 = CxfJaxRsClientConfigurator.getClientPolicy(conduit);
        policy1.setAllowChunking(config.isChunkingAllowed());
        policy1.setAsyncExecuteTimeout(config.getAsyncExecuteTimeout());
        policy1.setAsyncExecuteTimeoutRejection(config.isAsyncExecuteTimeoutRejection());
        policy1.setAutoRedirect(config.isFollowRedirectsAllowed());
        policy1.setChunkingThreshold(config.getChunkingThreshold());
        policy1.setChunkLength(config.getChunkLength());
        policy1.setConnection(CxfJaxRsClientConfigurator.asCxfConnectionType(config.getConnectionType()));
        policy1.setConnectionTimeout(config.getConnectionTimeout());
        policy1.setMaxRetransmits(config.getMaxRetransmits());
        policy1.setReceiveTimeout(config.getReceiveTimeout());
        if (config.isServerAuthorizationRequired() && !CxfJaxRsClientConfigurator.isOAuthEnabled(config)) {
            AuthorizationPolicy policy2 = CxfJaxRsClientConfigurator.getAuthorizationPolicy(conduit);
            policy2.setUserName(config.getServerUsername());
            policy2.setPassword(config.getServerPassword());
            policy2.setAuthorizationType(config.getServerAuthorizationType());
        }
    }

    @Override
    public void configureProxy(JaxRsClientConfig config, HTTPConduit conduit) {
        if (config.isProxyRequired()) {
            HTTPClientPolicy policy1 = CxfJaxRsClientConfigurator.getClientPolicy(conduit);
            policy1.setProxyServer(config.getProxyAddress());
            int proxyPort = config.getProxyPort();
            if (proxyPort > 0) {
                policy1.setProxyServerPort(proxyPort);
            }
            policy1.setNonProxyHosts(config.getNonProxyHosts());
            policy1.setProxyServerType(CxfJaxRsClientConfigurator.asProxyServerType(config.getProxyType()));
            if (config.isProxyAuthorizationRequired()) {
                ProxyAuthorizationPolicy policy3 = CxfJaxRsClientConfigurator.getProxyAuthorizationPolicy(conduit);
                policy3.setUserName(config.getProxyUsername());
                policy3.setPassword(config.getProxyPassword());
                policy3.setAuthorizationType(config.getProxyAuthorizationType());
            }
        }
    }

    protected List<Object> getOAuthProviders(JaxRsClientConfig config) {
        List<Object> providers = Collections.emptyList();
        if (CxfJaxRsClientConfigurator.isOAuthEnabled(config)) {
            OAuth2ClientRequestFilter filter = this.oauthFactory.newOAuthClientFilter(config.getServerUsername(), config.getServerPassword(), config.getOAuthClientId(), config.getOAuthClientSecret(), config.getOAuthAuthorizeUri(), config.getOAuthTokenUri(), config.getOAuthTokenValidationUri());
            if (config.isOAuthTokenCacheEnabled()) {
                int cacheMaxSize = config.getOAuthCacheMaxSize();
                long cacheEvictTimeoutMillis = config.getOAuthCacheEvictTimeoutMillis();
                OAuth2ClientRequestFilter.ClientAccessTokenCache cache = this.oauthFactory.newClientAccessTokenCache(cacheMaxSize, cacheEvictTimeoutMillis);
                filter.setClientAccessTokenCache(cache);
            }
            filter.setSecretKeyAlgorithm(config.getOAuthSecretKeyAlgorithm());
            filter.setSecretKeyEncoded(config.getOAuthEncodedSecretKey());
            filter.setFailOnRefreshTokenError(config.isOAuthFailsOnRefreshTokenError());
            filter.setRedirectUri(config.getOAuthRedirectUri());
            filter.setScopes(config.getOAuthScopes());
            filter.setTokenStore(config.getOAuthTokenStore());
            filter.setTokenHandler(config.getOAuthTokenHandler());
            providers = Collections.singletonList(filter);
        }
        return providers;
    }

    private static boolean isOAuthEnabled(JaxRsClientConfig config) {
        String clientId = config.getOAuthClientId();
        return Strings.isValid((String)clientId);
    }

    private static void register(ClientBuilder builder, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            builder.property(entry.getKey(), entry.getValue());
        }
    }

    private static void register(ClientBuilder builder, Iterable<? extends Object> objects) {
        for (Object object : objects) {
            builder.register(object);
        }
    }

    private static HTTPClientPolicy getClientPolicy(HTTPConduit conduit) {
        HTTPClientPolicy toReturn = conduit.getClient();
        if (toReturn == null) {
            toReturn = new HTTPClientPolicy();
            conduit.setClient(toReturn);
        }
        return toReturn;
    }

    private static AuthorizationPolicy getAuthorizationPolicy(HTTPConduit conduit) {
        AuthorizationPolicy toReturn = conduit.getAuthorization();
        if (toReturn == null) {
            toReturn = new AuthorizationPolicy();
            conduit.setAuthorization(toReturn);
        }
        return toReturn;
    }

    private static ProxyAuthorizationPolicy getProxyAuthorizationPolicy(HTTPConduit conduit) {
        ProxyAuthorizationPolicy toReturn = conduit.getProxyAuthorization();
        if (toReturn == null) {
            toReturn = new ProxyAuthorizationPolicy();
            conduit.setProxyAuthorization(toReturn);
        }
        return toReturn;
    }

    private static ProxyServerType asProxyServerType(JaxRsClientConstants.ProxyType type) {
        ProxyServerType toReturn = ProxyServerType.HTTP;
        if (JaxRsClientConstants.ProxyType.SOCKS == type) {
            toReturn = ProxyServerType.SOCKS;
        }
        return toReturn;
    }

    private static ConnectionType asCxfConnectionType(JaxRsClientConstants.ConnectionType type) {
        ConnectionType toReturn = ConnectionType.KEEP_ALIVE;
        if (JaxRsClientConstants.ConnectionType.CLOSE == type) {
            toReturn = ConnectionType.CLOSE;
        }
        return toReturn;
    }

    public static interface OAuthFactory {
        public OAuth2ClientRequestFilter newOAuthClientFilter(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

        public OAuth2ClientRequestFilter.ClientAccessTokenCache newClientAccessTokenCache(int var1, long var2);
    }
}

