/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client;

import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.client.JaxRsConfirmAccessHandler;
import org.eclipse.osee.jaxrs.client.JaxRsTokenStore;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Util;

public final class JaxRsClientConstants {
    private static final String NAMESPACE = "jaxrs.client";
    public static final String BASIC_AUTHENTICATION = "Basic";
    public static final String JAXRS_CLIENT_SERVER_USERNAME = JaxRsClientConstants.qualify("server.username");
    public static final String JAXRS_CLIENT_SERVER_PASSWORD = JaxRsClientConstants.qualify("server.password");
    public static final String JAXRS_CLIENT_SERVER_AUTHORIZATION_TYPE = JaxRsClientConstants.qualify("server.authorization.type");
    public static final String JAXRS_CLIENT_FOLLOW_REDIRECTS = JaxRsClientConstants.qualify("follow.redirects");
    public static final String JAXRS_CLIENT_CONNECTION_TIMEOUT = JaxRsClientConstants.qualify("connection.timeout");
    public static final String JAXRS_CLIENT_RECEIVE_TIMEOUT = JaxRsClientConstants.qualify("receive.timeout");
    public static final String JAXRS_CLIENT_ASYNC_EXECUTE_TIMEOUT = JaxRsClientConstants.qualify("async.exec.timeout");
    public static final String JAXRS_CLIENT_ASYNC_EXECUTE_TIMEOUT_REJECTION = JaxRsClientConstants.qualify("async.exec.timeout.rejection");
    public static final String JAXRS_CLIENT_MAX_RETRANSMITS = JaxRsClientConstants.qualify("max.retransmits");
    public static final String JAXRS_CLIENT_CHUNKING_ALLOWED = JaxRsClientConstants.qualify("is.chunking.allowed");
    public static final String JAXRS_CLIENT_CHUNKING_THRESHOLD = JaxRsClientConstants.qualify("chunking.threshold");
    public static final String JAXRS_CLIENT_CHUNK_SIZE = JaxRsClientConstants.qualify("chunk.size");
    public static final String JAXRS_CLIENT_CONNECTION_TYPE = JaxRsClientConstants.qualify("connection.type");
    public static final String JAXRS_CLIENT_PROXY_ADDRESS = JaxRsClientConstants.qualify("proxy.server.address");
    public static final String JAXRS_CLIENT_PROXY_TYPE = JaxRsClientConstants.qualify("proxy.server.type");
    public static final String JAXRS_CLIENT_NON_PROXY_HOSTS = JaxRsClientConstants.qualify("non.proxy.hosts");
    public static final String JAXRS_CLIENT_PROXY_USERNAME = JaxRsClientConstants.qualify("proxy.username");
    public static final String JAXRS_CLIENT_PROXY_PASSWORD = JaxRsClientConstants.qualify("proxy.password");
    public static final String JAXRS_CLIENT_PROXY_AUTHORIZATION_TYPE = JaxRsClientConstants.qualify("proxy.authorization.type");
    public static final String JAXRS_CLIENT_CREATE_THREADSAFE_PROXY_CLIENTS = JaxRsClientConstants.qualify("create.threadsafe.proxy.clients");
    public static final String JAXRS_CLIENT_PROXY_CLIENT_SUB_RESOURCES_INHERIT_HEADERS = JaxRsClientConstants.qualify("proxy.client.subresources.inherit.headers");
    public static final String JAXRS_CLIENT_OAUTH_AUTHORIZE_URI = JaxRsClientConstants.qualify("oauth.authorization.uri");
    public static final String JAXRS_CLIENT_OAUTH_TOKEN_URI = JaxRsClientConstants.qualify("oauth.token.uri");
    public static final String JAXRS_CLIENT_OAUTH_TOKEN_VALIDATION_URI = JaxRsClientConstants.qualify("oauth.token.validation.uri");
    public static final String JAXRS_CLIENT_OAUTH_CLIENT_ID = JaxRsClientConstants.qualify("oauth.client.id");
    public static final String JAXRS_CLIENT_OAUTH_CLIENT_SECRET = JaxRsClientConstants.qualify("oauth.client.secret");
    public static final String JAXRS_CLIENT_OAUTH_REDIRECT_URI = JaxRsClientConstants.qualify("oauth.redirect.uri");
    public static final String JAXRS_CLIENT_OAUTH_SCOPES = JaxRsClientConstants.qualify("oauth.scopes");
    public static final String JAXRS_CLIENT_OAUTH_SECRET_KEY_ALGORITHM = JaxRsClientConstants.qualify("oauth.secret.key.algorithm");
    public static final String JAXRS_CLIENT_OAUTH_ENCODED_SECRET_KEY = JaxRsClientConstants.qualify("oauth.secret.key");
    public static final String JAXRS_CLIENT_OAUTH_FAILS_ON_REFRESH_TOKEN_ERROR = JaxRsClientConstants.qualify("oauth.fails.on.refresh.token.error");
    public static final String JAXRS_CLIENT_OAUTH_CACHE_ENABLED = JaxRsClientConstants.qualify("oauth.cache.enabled");
    public static final String JAXRS_CLIENT_OAUTH_CACHE_MAX_SIZE = JaxRsClientConstants.qualify("oauth.cache.max.size");
    public static final String JAXRS_CLIENT_OAUTH_CACHE_EVICT_TIMEOUT_MILLIS = JaxRsClientConstants.qualify("oauth.cache.evict.timeout");
    public static final String DEFAULT_JAXRS_CLIENT_SERVER_USERNAME = null;
    public static final String DEFAULT_JAXRS_CLIENT_SERVER_PASSWORD = null;
    public static final String DEFAULT_JAXRS_CLIENT_SERVER_AUTHORIZATION_TYPE = "Basic";
    public static final boolean DEFAULT_JAXRS_CLIENT_FOLLOW_REDIRECTS = true;
    public static final long DEFAULT_JAXRS_CLIENT_CONNECTION_TIMEOUT = 30000L;
    public static final long DEFAULT_JAXRS_CLIENT_RECEIVE_TIMEOUT = 0L;
    public static final long DEFAULT_JAXRS_CLIENT_ASYNC_EXECUTE_TIMEOUT = 5000L;
    public static final boolean DEFAULT_JAXRS_CLIENT_ASYNC_EXECUTE_TIMEOUT_REJECTION = true;
    public static final int DEFAULT_JAXRS_CLIENT_MAX_RETRANSMITS = -1;
    public static final boolean DEFAULT_JAXRS_CLIENT_CHUNKING_ALLOWED = true;
    public static final int DEFAULT_JAXRS_CLIENT_CHUNKING_THRESHOLD = 4096;
    public static final int DEFAULT_JAXRS_CLIENT_CHUNK_SIZE = 0;
    public static final ConnectionType DEFAULT_JAXRS_CLIENT_CONNECTION_TYPE = ConnectionType.KEEP_ALIVE;
    public static final ProxyType DEFAULT_JAXRS_CLIENT_PROXY_TYPE = ProxyType.HTTP;
    public static final String DEFAULT_JAXRS_CLIENT_PROXY_ADDRESS = null;
    public static final int DEFAULT_JAXRS_CLIENT_PROXY_PORT = -1;
    public static final String DEFAULT_JAXRS_CLIENT_NON_PROXY_HOSTS = null;
    public static final String DEFAULT_JAXRS_CLIENT_PROXY_USERNAME = null;
    public static final String DEFAULT_JAXRS_CLIENT_PROXY_PASSWORD = null;
    public static final String DEFAULT_JAXRS_CLIENT_PROXY_AUTHORIZATION_TYPE = "Basic";
    public static final boolean DEFAULT_JAXRS_CLIENT_CREATE_THREADSAFE_PROXY_CLIENTS = false;
    public static final boolean DEFAULT_JAXRS_CLIENT_PROXY_CLIENT_SUB_RESOURCES_INHERIT_HEADERS = false;
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_AUTHORIZE_URI = null;
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_URI = null;
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_VALIDATION_URI = null;
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_CLIENT_ID = null;
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_CLIENT_SECRET = null;
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_SCOPES = null;
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_REDIRECT_URI = "urn:ietf:wg:oauth:2.0:oob";
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_SECRET_KEY_ALGORITHM = null;
    public static final String DEFAULT_JAXRS_CLIENT_OAUTH_ENCODED_SECRET_KEY = null;
    public static final boolean DEFAULT_JAXRS_CLIENT_OAUTH_FAILS_ON_REFRESH_TOKEN_ERROR = false;
    public static final boolean DEFAULT_JAXRS_CLIENT_OAUTH_CACHE_ENABLED = true;
    public static final int DEFAULT_JAXRS_CLIENT_OAUTH_CACHE_MAX_SIZE = 100;
    public static final long DEFAULT_JAXRS_CLIENT_OAUTH_CACHE_EVICT_TIMEOUT_MILLIS = 3600000L;
    public static final JaxRsConfirmAccessHandler OAUTH_ACCEPT_ALL_CONFIRM_HANDLER;
    public static final JaxRsConfirmAccessHandler DEFAULT_JAXRS_CLIENT_OAUTH_CONFIRM_ACCESS_HANDLER;
    public static final JaxRsTokenStore DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_STORE;
    public static int RETRANSMIT_MIN_LIMIT;
    public static int PORT_MIN_LIMIT;
    public static long TIMEOUT_MIN_LIMIT;
    public static int CHUNK_LENGTH_MIN_LIMIT;
    public static int CHUNK_THRESHOLD_MIN_LIMIT;

    static {
        DEFAULT_JAXRS_CLIENT_OAUTH_CONFIRM_ACCESS_HANDLER = OAUTH_ACCEPT_ALL_CONFIRM_HANDLER = OAuth2Util.newAcceptAllTokenHandler();
        DEFAULT_JAXRS_CLIENT_OAUTH_TOKEN_STORE = null;
        RETRANSMIT_MIN_LIMIT = -1;
        PORT_MIN_LIMIT = -1;
        TIMEOUT_MIN_LIMIT = 0L;
        CHUNK_LENGTH_MIN_LIMIT = 0;
        CHUNK_THRESHOLD_MIN_LIMIT = 4096;
    }

    private JaxRsClientConstants() {
    }

    static String qualify(String value) {
        return String.format("%s.%s", NAMESPACE, value);
    }

    public static enum ConnectionType {
        CLOSE,
        KEEP_ALIVE;


        public static ConnectionType parse(String value) {
            ConnectionType toReturn = KEEP_ALIVE;
            if (Strings.isValid((String)value)) {
                String toFind = value.toUpperCase().trim();
                ConnectionType[] connectionTypeArray = ConnectionType.values();
                int n = connectionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionType type = connectionTypeArray[n2];
                    if (type.name().equals(toFind)) {
                        toReturn = type;
                        break;
                    }
                    ++n2;
                }
            }
            return toReturn;
        }
    }

    public static enum ProxyType {
        HTTP,
        SOCKS;


        public static ProxyType parse(String value) {
            ProxyType toReturn = HTTP;
            if (Strings.isValid((String)value)) {
                String toFind = value.toUpperCase().trim();
                ProxyType[] proxyTypeArray = ProxyType.values();
                int n = proxyTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ProxyType type = proxyTypeArray[n2];
                    if (type.name().equals(toFind)) {
                        toReturn = type;
                        break;
                    }
                    ++n2;
                }
            }
            return toReturn;
        }
    }
}

