/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.applicability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.PathParam;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityData;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.VariantDefinition;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ApplicabilityEndpointImpl
implements ApplicabilityEndpoint {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final ApplicabilityQuery applicabilityQuery;
    private final UserId account;
    private final OrcsApplicability ops;

    public ApplicabilityEndpointImpl(OrcsApi orcsApi, BranchId branch, UserId account) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.applicabilityQuery = orcsApi.getQueryFactory().applicabilityQuery();
        this.account = account;
        this.ops = orcsApi.getApplicabilityOps();
    }

    public Collection<ApplicabilityToken> getApplicabilityTokens() {
        return this.applicabilityQuery.getApplicabilityTokens(this.branch).values();
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> artIds) {
        return this.applicabilityQuery.getApplicabilityTokens(artIds, this.branch);
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId) {
        return this.applicabilityQuery.getApplicabilityToken(artId, this.branch);
    }

    public List<ApplicabilityId> getApplicabilitiesReferenced(ArtifactId artifact) {
        return this.applicabilityQuery.getApplicabilitiesReferenced(artifact, this.branch);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokensForArts(Collection<? extends ArtifactId> artIds) {
        ArrayList<Pair<ArtifactId, ApplicabilityToken>> artToApplicToken = new ArrayList<Pair<ArtifactId, ApplicabilityToken>>();
        for (ArtifactId artifactId : artIds) {
            artToApplicToken.add((Pair<ArtifactId, ApplicabilityToken>)new Pair((Object)artifactId, (Object)this.getApplicabilityToken(artifactId)));
        }
        return artToApplicToken;
    }

    public List<ApplicabilityToken> getApplicabilityReferenceTokens(ArtifactId artifact) {
        return this.applicabilityQuery.getApplicabilityReferenceTokens(artifact, this.branch);
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId view) {
        return this.applicabilityQuery.getViewApplicabilityTokens(view, this.branch);
    }

    public List<ArtifactToken> getViews() {
        return this.applicabilityQuery.getViewForBranch(this.branch);
    }

    public List<FeatureDefinition> getFeatureDefinitionData() {
        return this.applicabilityQuery.getFeatureDefinitionData(this.branch);
    }

    public List<BranchId> getAffectedBranches(Long injectDateMs, Long removalDateMs, List<ApplicabilityId> applicabilityIds) {
        return this.applicabilityQuery.getAffectedBranches(injectDateMs, removalDateMs, applicabilityIds, this.branch);
    }

    public List<BranchId> getAffectedBranches(TransactionId injectionTx, TransactionId removalTx, List<ApplicabilityId> applicabilityIds) {
        return this.applicabilityQuery.getAffectedBranches(injectionTx, removalTx, applicabilityIds, this.branch);
    }

    public TransactionToken setApplicability(ApplicabilityId applicId, List<? extends ArtifactId> artifacts) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Set Applicability Ids for Artifacts");
        tx.setApplicability(applicId, artifacts);
        return tx.commit();
    }

    public TransactionToken setApplicabilityReference(List<ApplicabilityData> appDatas) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Set Reference Applicability Ids for Artifacts");
        HashMap<ArtifactId, List> artToApplMap = new HashMap<ArtifactId, List>();
        for (ApplicabilityData data : appDatas) {
            artToApplMap.put(data.getArtifact(), Collections.castAll((Collection)data.getApplIds()));
        }
        tx.setApplicabilityReference(artToApplMap);
        return tx.commit();
    }

    public ArtifactToken createView(String viewName) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return ArtifactToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Create Branch View");
        ArtifactToken view = tx.createView(this.branch, viewName);
        tx.commit();
        TransactionBuilder tx2 = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, this.account, "Create Branch View");
        tx2.addTuple2(CoreTupleTypes.BranchView, (Object)this.branch, (Object)view);
        tx2.commit();
        return view;
    }

    public TransactionToken copyView(ArtifactId sourceView, String viewName) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        ArtifactToken view = this.createView(viewName);
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Copy Branch View");
        List viewApplicabilityTokens = this.applicabilityQuery.getViewApplicabilityTokens(sourceView, this.branch);
        for (ApplicabilityToken applicToken : viewApplicabilityTokens) {
            String name = applicToken.getName();
            if (this.applicabilityQuery.applicabilityExistsOnBranchView(this.branch, (ArtifactId)view, name) || name.startsWith("Config = ")) continue;
            tx.createApplicabilityForView((ArtifactId)view, name);
        }
        return tx.commit();
    }

    public XResultData createApplicabilityForView(ArtifactId viewId, String applicability) {
        XResultData results = this.isAccess();
        if (results.isErrors()) {
            return results;
        }
        if (!this.applicabilityQuery.viewExistsOnBranch(this.branch, viewId)) {
            results.error("View is invalid.");
            return results;
        }
        if (this.applicabilityQuery.applicabilityExistsOnBranchView(this.branch, viewId, applicability)) {
            results.error("Applicability already exists.");
        }
        if (applicability.startsWith("Config =")) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Create " + applicability + " applicability");
            tx.createApplicabilityForView(viewId, applicability);
            tx.commit();
            return results;
        }
        if (applicability.contains("|")) {
            boolean validApplicability = true;
            String[] stringArray = applicability.split("|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, this.branch, (Object)viewId);
                for (String appl : existingApps) {
                    if (!appl.equals(value)) continue;
                    validApplicability = true;
                }
                ++n2;
            }
            if (validApplicability) {
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Apply " + applicability + " applicability");
                tx.createApplicabilityForView(viewId, applicability);
                tx.commit();
            }
        } else {
            String featureName = applicability.substring(0, applicability.indexOf("=") - 1);
            String featureValue = applicability.substring(applicability.indexOf("=") + 2);
            if (this.applicabilityQuery.featureExistsOnBranch(this.branch, featureName) && this.applicabilityQuery.featureValueIsValid(this.branch, featureName, featureValue)) {
                LinkedList<String> existingValues = new LinkedList<String>();
                Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, this.branch, (Object)viewId);
                for (String appl : existingApps) {
                    if (!appl.startsWith(String.valueOf(featureName) + " = ") && !appl.contains("| " + featureName + "=")) continue;
                    existingValues.add(appl);
                }
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Apply " + applicability + " applicability");
                for (String existingValue : existingValues) {
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)existingValue);
                }
                tx.createApplicabilityForView(viewId, applicability);
                tx.commit();
            } else {
                results.error("Feature is not defined or Value is invalid.");
            }
        }
        return results;
    }

    public void addMissingApplicabilityFromParentBranch() {
        this.orcsApi.getBranchOps().addMissingApplicabilityFromParentBranch(this.branch);
    }

    public ArtifactId getVersionConfig(ArtifactId version) {
        return this.applicabilityQuery.getVersionConfig(version, this.branch);
    }

    public String getViewTable(String filter) {
        return this.applicabilityQuery.getViewTable(this.branch, filter);
    }

    public FeatureDefinition getFeature(String feature) {
        return this.ops.getFeature(feature, this.branch);
    }

    public XResultData createUpdateFeature(FeatureDefinition feature, @PathParam(value="action") String action) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createUpdateFeature(feature, action, this.branch, this.account);
    }

    public XResultData deleteFeature(ArtifactId feature) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteFeature(feature, this.branch, this.account);
    }

    public XResultData createUpdateVariant(VariantDefinition variant, @PathParam(value="action") String action) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createUpdateVariant(variant, action, this.branch, this.account);
    }

    public XResultData deleteVariant(@PathParam(value="variant") String variant) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteVariant(variant, this.branch, this.account);
    }

    public VariantDefinition getVariant(String variant) {
        return this.ops.getVariant(variant, this.branch);
    }

    public XResultData setApplicability(ArtifactId variant, ArtifactId feature, String applicability) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.setApplicability(this.branch, variant, feature, applicability, this.account);
    }

    public XResultData isAccess() {
        Branch brch;
        XResultData rd = new XResultData();
        if (OseeProperties.isInTest()) {
            rd.logf("Access granted to branch cause isInTest", new Object[0]);
        }
        if ((brch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(this.branch)).getResults().getAtMostOneOrNull()).getBranchType() == BranchType.WORKING) {
            rd.log("Access granted to working branch");
        } else {
            rd.error("Access denied to non-working branch");
        }
        return rd;
    }
}

