/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.framework.resource.management.StandardOptions;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.ResourcesEndpoint;

public class ResourcesEndpointImpl
implements ResourcesEndpoint {
    private final IResourceManager resourceManager;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders httpHeaders;

    public ResourcesEndpointImpl(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public void setHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public Response getResource(String path, boolean decompressOnAquire, boolean compressOnAcquire) {
        IResourceLocator locator = null;
        String uriLocator = this.asUriLocator(this.getHeaders(), path);
        try {
            locator = this.resourceManager.getResourceLocator(uriLocator);
        }
        catch (Exception ex) {
            throw new OseeWebApplicationException((Throwable)ex, (Response.StatusType)Response.Status.BAD_REQUEST, "Unable to locate [%s]", new Object[]{path});
        }
        PropertyStore options = new PropertyStore();
        options.put(StandardOptions.DecompressOnAquire.name(), String.valueOf(decompressOnAquire));
        options.put(StandardOptions.CompressOnAcquire.name(), String.valueOf(compressOnAcquire));
        final IResource resource = this.resourceManager.acquire(locator, options);
        if (resource == null) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "Unable to locate [%s]", new Object[]{path});
        }
        Response.ResponseBuilder builder = Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                InputStream inputStream = resource.getContent();
                try {
                    Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)output);
                }
                finally {
                    Lib.close((AutoCloseable)inputStream);
                }
            }
        });
        String contentType = this.getContentType(resource);
        if (Strings.isValid((String)contentType)) {
            builder.header("Content-Type", (Object)contentType);
        }
        builder.header("Content-Disposition", (Object)("attachment; filename=" + resource.getName()));
        return builder.build();
    }

    public Response saveResource(InputStream inputStream, String protocol, String resourceId, String resourceName, boolean overwriteAllowed, boolean compressOnSave) {
        MediaType mediaType;
        boolean isCompressed = false;
        if (!Strings.isValid((String)resourceName)) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "resource name cannot be null", new Object[0]);
        }
        String resource = resourceName;
        String extension = Lib.getExtension((String)resourceName);
        if (!Strings.isValid((String)extension) && (mediaType = this.getAcceptableMediaType(this.httpHeaders)) != null && Strings.isValid((String)(extension = this.getFileExtension(mediaType)))) {
            resource = String.format("%s.%s", resourceName, extension);
        }
        if (Strings.isValid((String)extension)) {
            isCompressed = extension.contains("zip") || extension.contains("tar");
        } else {
            HttpHeaders httpHeaders = this.getHeaders();
            String contentType = httpHeaders.getHeaderString("Content-Type");
            if (Strings.isValid((String)contentType)) {
                isCompressed = contentType.contains("zip") || contentType.contains("tar");
            }
        }
        IResourceLocator tempLocator = this.resourceManager.generateResourceLocator(protocol, resourceId, resource);
        IResource tempResource = ResourcesEndpointImpl.newResource(tempLocator, isCompressed, new BufferedInputStream(inputStream));
        PropertyStore options = new PropertyStore();
        options.put(StandardOptions.CompressOnSave.name(), compressOnSave);
        options.put(StandardOptions.Overwrite.name(), overwriteAllowed);
        IResourceLocator locator = this.resourceManager.save(tempLocator, tempResource, options);
        UriInfo uriInfo = this.getUriInfo();
        URI location = this.getResourceLocation(uriInfo, locator);
        return Response.created((URI)location).build();
    }

    private URI getResourceLocation(UriInfo uriInfo, IResourceLocator locator) {
        UriBuilder builder = uriInfo.getBaseUriBuilder();
        URI location = builder.path("resources").path(locator.getProtocol()).path(locator.getRawPath()).build(new Object[0]);
        return location;
    }

    public Response deleteResource(String path) {
        IResourceLocator locator = null;
        String uriLocator = this.asUriLocator(this.getHeaders(), path);
        try {
            locator = this.resourceManager.getResourceLocator(uriLocator);
        }
        catch (Exception ex) {
            throw new OseeWebApplicationException((Throwable)ex, (Response.StatusType)Response.Status.BAD_REQUEST, "Unable to locate [%s]", new Object[]{path});
        }
        boolean modified = false;
        int status = this.resourceManager.delete(locator);
        if (status == 1) {
            modified = true;
        }
        return OrcsRestUtil.asResponse(modified);
    }

    private String asUriLocator(HttpHeaders headers, String itemPath) {
        int firstSlash;
        StringBuilder builder = new StringBuilder();
        if (Strings.isValid((String)itemPath) && (firstSlash = itemPath.indexOf(47)) > 0 && firstSlash + 1 < itemPath.length()) {
            String protocol = itemPath.substring(0, firstSlash);
            builder.append(protocol);
            builder.append("://");
            String path = itemPath.substring(firstSlash + 1);
            builder.append(path);
        }
        return builder.toString();
    }

    private MediaType getAcceptableMediaType(HttpHeaders headers) {
        MediaType mediaType = headers.getMediaType();
        if (mediaType == null) {
            for (MediaType type : headers.getAcceptableMediaTypes()) {
                String subtype = type.getSubtype();
                if (!Strings.isValid((String)subtype)) continue;
                mediaType = type;
                break;
            }
        }
        return mediaType;
    }

    private String getFileExtension(MediaType mediaType) {
        String extension = MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType) ? "txt" : mediaType.getSubtype();
        return extension;
    }

    private String getContentType(IResource resource) {
        String contentType;
        block6: {
            contentType = null;
            InputStream inputStream = null;
            try {
                try {
                    inputStream = resource.getContent();
                    contentType = URLConnection.guessContentTypeFromStream(inputStream);
                }
                catch (IOException iOException) {
                    Lib.close((AutoCloseable)inputStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Lib.close((AutoCloseable)inputStream);
                throw throwable;
            }
            Lib.close((AutoCloseable)inputStream);
        }
        if (contentType == null && (contentType = URLConnection.guessContentTypeFromName(resource.getLocation().toASCIIString())) == null) {
            contentType = "application/*";
        }
        return contentType;
    }

    private static IResource newResource(final IResourceLocator locator, final boolean isCompressed, final InputStream stream) {
        return new IResource(){

            public InputStream getContent() {
                return stream;
            }

            public URI getLocation() {
                return locator.getLocation();
            }

            public String getName() {
                String path = locator.getLocation().toASCIIString();
                int index = path.lastIndexOf("/");
                if (index != -1 && index + 1 < path.length()) {
                    path = path.substring(index + 1, path.length());
                }
                return path;
            }

            public boolean isCompressed() {
                return isCompressed;
            }
        };
    }
}

