/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.validation;

import com.google.inject.Inject;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.script.dsl.IExpressionResolver;
import org.eclipse.osee.orcs.script.dsl.IFieldResolver;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptUtil;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OrcsScriptDslPackage;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectFieldExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectObjectExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxTimestampOpClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxTimestampRangeClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsVariable;
import org.eclipse.osee.orcs.script.dsl.validation.AbstractOrcsScriptDslJavaValidator;
import org.eclipse.xtext.validation.Check;

public class OrcsScriptDslJavaValidator
extends AbstractOrcsScriptDslJavaValidator {
    @Inject
    private IExpressionResolver resolver;
    @Inject
    private IFieldResolver fieldResolver;

    @Check
    public void checkOsVariable(OsVariable variable) {
        String variableName = variable.getName();
        if (!Character.isLowerCase(variableName.charAt(0))) {
            this.warning("Variable name should start with lowercase", (EStructuralFeature)OrcsScriptDslPackage.Literals.OS_VARIABLE__NAME, "invalid_variable__name", new String[]{variableName});
        }
    }

    @Check
    public void checkOsTxTimestampRangeValidity(OsTxTimestampRangeClause clause) {
        Date fromDate = this.checkAndGetDate(clause.getFrom(), 1);
        Date toDate = this.checkAndGetDate(clause.getTo(), 2);
        if (fromDate != null && toDate != null && fromDate.after(toDate)) {
            String from = OrcsScriptUtil.asDateString(fromDate);
            String to = OrcsScriptUtil.asDateString(toDate);
            String msg = String.format("Invalid timestamp range - start date [%s] is after end date [%s]", from, to);
            this.error(msg, null, 59, "invalid_timestamp__range", new String[0]);
        }
    }

    private Date checkAndGetDate(OsExpression expression, int featureId) {
        Date toReturn = null;
        try {
            toReturn = this.resolver.resolveSingle(Date.class, expression);
        }
        catch (Exception ex) {
            this.error(ex.getMessage(), null, featureId, "invalid_timestamp__bad_format", new String[0]);
        }
        return toReturn;
    }

    @Check
    public void checkOsTxTimestampRangeValidity(OsTxTimestampOpClause clause) {
        OsExpression expression = clause.getTimestamp();
        this.checkAndGetDate(expression, 1);
    }

    @Check
    public void checkOsCollectObjectExpression(OsCollectObjectExpression object) {
        Set<? extends IFieldResolver.OsField> unallowed = this.fieldResolver.getNotAllowedDeclaredFields(object);
        if (!unallowed.isEmpty()) {
            Set<? extends IFieldResolver.OsField> allowedFields = this.fieldResolver.getAllowedFields(object);
            String msg = String.format("Invalid collect statement - invalid field(s) detected %s. The following fields are allowed: %s", unallowed, allowedFields);
            this.error(msg, null, 2, "invalid_collect_stmt__invalid_field", new String[0]);
        }
    }

    @Check
    public void checkOsCollectClause(OsCollectClause clause) {
        HashSet<String> aliases = new HashSet<String>();
        HashSet<String> collisions = new HashSet<String>();
        OsCollectExpression expression = clause.getExpression();
        this.collectAliasHelper(expression, aliases, collisions);
        if (!collisions.isEmpty()) {
            String msg = String.format("Invalid collect statement - ambiguous name(s) detected %s.", collisions);
            this.error(msg, null, 10, "invalid_collect_stmt__ambiguous_alias", new String[0]);
        }
    }

    private void collectAliasHelper(OsCollectExpression expression, Set<String> aliases, Set<String> collisions) {
        OsExpression aliasExpression = null;
        EList<OsCollectExpression> expressions = null;
        if (expression instanceof OsCollectFieldExpression) {
            OsCollectFieldExpression fieldExp = (OsCollectFieldExpression)expression;
            aliasExpression = fieldExp.getAlias();
        } else if (expression instanceof OsCollectObjectExpression) {
            OsCollectObjectExpression objExpr = (OsCollectObjectExpression)expression;
            aliasExpression = objExpr.getAlias();
            expressions = objExpr.getExpressions();
        }
        if (aliasExpression != null) {
            boolean added;
            String alias = this.resolver.resolveSingle(String.class, aliasExpression);
            if (!Strings.isValid((String)alias)) {
                alias = expression.getName();
            }
            if (!(added = aliases.add(alias))) {
                collisions.add(alias);
            }
        }
        if (expressions != null) {
            for (OsCollectExpression child : expressions) {
                this.collectAliasHelper(child, aliases, collisions);
            }
        }
    }
}

