/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl;

import com.google.common.base.Supplier;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.osee.orcs.script.dsl.IFieldResolver;

public enum OsFieldEnum implements IFieldResolver.OsField
{
    branch_id("id"),
    branch_type("type"),
    branch_name("name"),
    branch_state("state"),
    branch_archive_state("archived"),
    branch_parent_id("parent-id"),
    branch_parent_tx_id("parent-tx-id"),
    branch_baseline_tx_id("baseline-tx-id"),
    branch_inherit_access_cntrl("inherits-access-control"),
    branch_associated_art_id("assoc-id"),
    tx_id("id"),
    tx_current("current"),
    tx_type("type"),
    tx_comment("comment"),
    tx_date("date"),
    tx_branch_id("branch-id"),
    tx_author_id("author-id"),
    tx_commit_id("commit-id"),
    art_id("id"),
    art_type("type"),
    art_gamma_id("gamma-id"),
    art_guid("guid"),
    art_mod_type("mod-type"),
    art_txs("txs", Family.ARTIFACT, Family.ARTIFACT_TX),
    art_tx_id("id"),
    art_tx_current("current"),
    art_tx_branch_id("branch-id"),
    art_tx_type("type"),
    art_tx_comment("comment"),
    art_tx_date("date"),
    art_tx_author_id("author-id"),
    art_tx_commit_id("commit-id"),
    attributes("attributes", Family.ARTIFACT, Family.ATTRIBUTE),
    attr_id("id"),
    attr_type("type"),
    attr_gamma_id("gamma-id"),
    attr_ds_value("ds-value"),
    attr_ds_uri("ds-uri"),
    attr_value("value"),
    attr_mod_type("mod-type"),
    attr_txs("txs", Family.ATTRIBUTE, Family.ATTRIBUTE_TX),
    attr_tx_id("id"),
    attr_tx_current("current"),
    attr_tx_branch_id("branch-id"),
    attr_tx_type("type"),
    attr_tx_comment("comment"),
    attr_tx_date("date"),
    attr_tx_author_id("author-id"),
    attr_tx_commit_id("commit-id"),
    relations("relations", Family.ARTIFACT, Family.RELATION),
    rel_id("id"),
    rel_type("type"),
    rel_gamma_id("gamma-id"),
    rel_rationale("rationale"),
    rel_mod_type("mod-type"),
    rel_a_art_id("side-A-id"),
    rel_b_art_id("side-B-id"),
    rel_txs("txs", Family.RELATION, Family.RELATION_TX),
    rel_tx_id("id"),
    rel_tx_current("current"),
    rel_tx_branch_id("branch-id"),
    rel_tx_type("type"),
    rel_tx_comment("comment"),
    rel_tx_date("date"),
    rel_tx_author_id("author-id"),
    rel_tx_commit_id("commit-id");

    private static final Comparator<IFieldResolver.OsField> FIELD_COMPARATOR;
    private static SortedSetMultimap<Family, ? extends IFieldResolver.OsField> FAMILY_TO_FIELDS;
    private static Table<Family, String, IFieldResolver.OsField> FAMILY_AND_NAME_TO_FIELDS;
    private final Family family;
    private final String fieldName;
    private final Family childFamily;

    static {
        FIELD_COMPARATOR = new FieldComparator();
    }

    private OsFieldEnum(String fieldName) {
        this(fieldName, null, Family.UNDEFINED);
    }

    private OsFieldEnum(String fieldName, Family family, Family childFamily) {
        this.fieldName = fieldName;
        this.family = family != null ? family : OsFieldEnum.family(this);
        this.childFamily = childFamily;
    }

    @Override
    public String getLiteral() {
        return this.fieldName;
    }

    public Family getFamily() {
        return this.family;
    }

    @Override
    public boolean hasChildren() {
        return this.childFamily != Family.UNDEFINED;
    }

    @Override
    public Set<? extends IFieldResolver.OsField> getChildren() {
        return OsFieldEnum.getFieldsFor(this.childFamily);
    }

    @Override
    public String getId() {
        return this.name();
    }

    public String toString() {
        return this.getLiteral();
    }

    public static Comparator<IFieldResolver.OsField> getComparator() {
        return FIELD_COMPARATOR;
    }

    public static SortedSet<? extends IFieldResolver.OsField> getFieldsFor(Family family) {
        if (FAMILY_TO_FIELDS == null) {
            SortedSetMultimap familyToFields = OsFieldEnum.newSetMultimap(FIELD_COMPARATOR);
            OsFieldEnum[] osFieldEnumArray = OsFieldEnum.values();
            int n = osFieldEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                OsFieldEnum field = osFieldEnumArray[n2];
                familyToFields.put((Object)field.getFamily(), (Object)field);
                ++n2;
            }
            FAMILY_TO_FIELDS = familyToFields;
        }
        return FAMILY_TO_FIELDS.get((Object)family);
    }

    public static IFieldResolver.OsField getField(Family family, String fieldName) {
        if (FAMILY_AND_NAME_TO_FIELDS == null) {
            HashBasedTable table = HashBasedTable.create();
            OsFieldEnum[] osFieldEnumArray = OsFieldEnum.values();
            int n = osFieldEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                OsFieldEnum field = osFieldEnumArray[n2];
                table.put((Object)field.getFamily(), (Object)field.getLiteral(), (Object)field);
                ++n2;
            }
            FAMILY_AND_NAME_TO_FIELDS = table;
        }
        return (IFieldResolver.OsField)FAMILY_AND_NAME_TO_FIELDS.get((Object)family, (Object)fieldName);
    }

    private static Family family(OsFieldEnum value) {
        Family family = Family.UNDEFINED;
        String name = value.name();
        if (name.startsWith("br")) {
            family = Family.BRANCH;
        } else if (name.startsWith("tx")) {
            family = Family.TX;
        } else if (name.startsWith("art_tx")) {
            family = Family.ARTIFACT_TX;
        } else if (name.startsWith("attr_tx")) {
            family = Family.ATTRIBUTE_TX;
        } else if (name.startsWith("rel_tx")) {
            family = Family.RELATION_TX;
        } else if (name.startsWith("art")) {
            family = Family.ARTIFACT;
        } else if (name.startsWith("attr")) {
            family = Family.ATTRIBUTE;
        } else if (name.startsWith("rel")) {
            family = Family.RELATION;
        }
        return family;
    }

    private static <K, V> SortedSetMultimap<K, V> newSetMultimap(final Comparator<V> comparator) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        return Multimaps.newSortedSetMultimap((Map)map, (Supplier)new Supplier<SortedSet<V>>(){

            public SortedSet<V> get() {
                return Sets.newTreeSet((Comparator)comparator);
            }
        });
    }

    public static IFieldResolver.OsField newField(String value) {
        return new OsFieldImpl(value);
    }

    public static enum Family {
        UNDEFINED,
        BRANCH,
        TX,
        ARTIFACT,
        ARTIFACT_TX,
        ATTRIBUTE,
        ATTRIBUTE_TX,
        RELATION,
        RELATION_TX;

    }

    private static class FieldComparator
    implements Comparator<IFieldResolver.OsField> {
        private FieldComparator() {
        }

        @Override
        public int compare(IFieldResolver.OsField o1, IFieldResolver.OsField o2) {
            String literal1 = this.normalize(o1.getLiteral());
            String literal2 = this.normalize(o2.getLiteral());
            return literal1.compareTo(literal2);
        }

        private String normalize(String value) {
            String toReturn = value;
            if (toReturn.equals("attributes")) {
                toReturn = "z1" + toReturn;
            } else if (toReturn.equals("relations")) {
                toReturn = "z2" + toReturn;
            } else if (toReturn.equals("txs")) {
                toReturn = "z0" + toReturn;
            }
            return toReturn;
        }
    }

    private static final class OsFieldImpl
    implements IFieldResolver.OsField,
    Comparable<IFieldResolver.OsField> {
        private final String fieldName;

        public OsFieldImpl(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String getId() {
            return this.fieldName;
        }

        @Override
        public int compareTo(IFieldResolver.OsField o) {
            return this.fieldName.compareTo(o.getLiteral());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OsFieldImpl other = (OsFieldImpl)obj;
            return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
        }

        @Override
        public String getLiteral() {
            return this.fieldName;
        }

        public String toString() {
            return this.getLiteral();
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public Set<? extends IFieldResolver.OsField> getChildren() {
            return Collections.emptySet();
        }
    }
}

