/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osee.account.rest.model.Link;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountWebPreferences {
    Map<String, Link> linksMap = new HashMap<String, Link>();

    public AccountWebPreferences() {
    }

    public AccountWebPreferences(Map<String, String> teamToPreferences) {
        for (String team : teamToPreferences.keySet()) {
            this.initPreferences(teamToPreferences.get(team), team);
        }
    }

    private void initPreferences(String string, String team) {
        try {
            JSONObject jObject = new JSONObject(string);
            JSONObject linkJsonObject = jObject.getJSONObject("links");
            Iterator keys = linkJsonObject.keys();
            while (keys.hasNext()) {
                String next = (String)keys.next();
                JSONObject linkJObject = linkJsonObject.getJSONObject(next);
                Link link = new Link();
                if (linkJObject.has("name")) {
                    link.setName(linkJObject.getString("name"));
                }
                if (linkJObject.has("url")) {
                    link.setUrl(linkJObject.getString("url"));
                }
                if (linkJObject.has("tags")) {
                    JSONArray array = linkJObject.getJSONArray("tags");
                    int x = 0;
                    while (x < array.length()) {
                        link.getTags().add(array.getString(x));
                        ++x;
                    }
                }
                link.setTeam(team);
                link.setId(linkJObject.getString("id"));
                this.linksMap.put(next, link);
            }
        }
        catch (JSONException jSONException) {}
    }

    public AccountWebPreferences(String jsonString, String team) {
        this.initPreferences(jsonString, team);
    }

    public Map<String, Link> getLinks() {
        return this.linksMap;
    }

    public void setLinks(Map<String, Link> links) {
        this.linksMap = links;
    }
}

