/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesIndexProvider;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesLoaderFactory;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesResourceProvider;
import org.eclipse.osee.orcs.core.internal.types.impl.ArtifactTypesImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.AttributeTypesImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.EnumTypesImpl;
import org.eclipse.osee.orcs.core.internal.types.impl.RelationTypesImpl;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.data.EnumTypes;
import org.eclipse.osee.orcs.data.RelationTypes;

public class OrcsTypesImpl
implements OrcsTypes {
    private final OrcsTypesIndexProvider indexProvider;
    private final Log logger;
    private final OrcsSession session;
    private final OrcsTypesDataStore dataStore;
    private final OrcsTypesLoaderFactory loaderFactory;
    private final ArtifactTypes artifactTypes;
    private final AttributeTypes attributeTypes;
    private final RelationTypes relationTypes;
    private final EnumTypes enumTypes;

    public OrcsTypesImpl(Log logger, OrcsSession session, OrcsTypesDataStore dataStore, OrcsTypesLoaderFactory loaderFactory, OrcsTypesIndexProvider indexProvider) {
        this.logger = logger;
        this.session = session;
        this.dataStore = dataStore;
        this.loaderFactory = loaderFactory;
        this.indexProvider = indexProvider;
        this.artifactTypes = new ArtifactTypesImpl(indexProvider);
        this.attributeTypes = new AttributeTypesImpl(indexProvider, indexProvider);
        this.relationTypes = new RelationTypesImpl(indexProvider);
        this.enumTypes = new EnumTypesImpl(indexProvider);
    }

    public ArtifactTypes getArtifactTypes() {
        return this.artifactTypes;
    }

    public AttributeTypes getAttributeTypes() {
        return this.attributeTypes;
    }

    public RelationTypes getRelationTypes() {
        return this.relationTypes;
    }

    public EnumTypes getEnumTypes() {
        return this.enumTypes;
    }

    public void invalidateAll() {
        this.indexProvider.invalidate();
    }

    public void loadTypes(final IResource resource) {
        this.indexProvider.setLoader(this.loaderFactory.createTypesLoader(this.session, new OrcsTypesResourceProvider(){

            @Override
            public IResource getOrcsTypesResource() {
                return resource;
            }
        }));
    }

    public void loadTypes(String model) {
        try {
            this.loadTypes(new ByteResource("http.osee.model", model.getBytes("UTF-8")));
            this.invalidateAll();
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public Callable<Void> writeTypes(final OutputStream outputStream) {
        return new CancellableCallable<Void>(){

            public Void call() throws Exception {
                OrcsTypesImpl.this.logger.trace("Writing OrcsTypes for session [%s]", new Object[]{OrcsTypesImpl.this.session});
                IResource resource = OrcsTypesImpl.this.indexProvider.getOrcsTypesResource();
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = resource.getContent();
                        this.checkForCancelled();
                        Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Exception ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                        Lib.close((AutoCloseable)inputStream);
                        Lib.close((AutoCloseable)outputStream);
                    }
                }
                finally {
                    Lib.close((AutoCloseable)inputStream);
                    Lib.close((AutoCloseable)outputStream);
                }
                return null;
            }
        };
    }

    public Callable<Void> purgeArtifactsByArtifactType(Collection<? extends ArtifactTypeToken> artifactTypes) {
        return this.dataStore.purgeArtifactsByArtifactType(this.session, artifactTypes);
    }

    public Callable<Void> purgeAttributesByAttributeType(Collection<? extends AttributeTypeId> attributeTypes) {
        return this.dataStore.purgeAttributesByAttributeType(this.session, attributeTypes);
    }

    public Callable<Void> purgeRelationsByRelationType(Collection<? extends IRelationType> relationTypes) {
        return this.dataStore.purgeRelationsByRelationType(this.session, relationTypes);
    }

    private static final class ByteResource
    implements IResource {
        private final String filename;
        private final byte[] bytes;

        public ByteResource(String filename, byte[] bytes) {
            this.filename = filename;
            this.bytes = bytes;
        }

        public InputStream getContent() {
            return new ByteArrayInputStream(this.bytes);
        }

        public URI getLocation() {
            String modelName = this.filename;
            if (!modelName.endsWith(".osee")) {
                modelName = String.valueOf(modelName) + ".osee";
            }
            try {
                return new URI("osee:/" + modelName);
            }
            catch (URISyntaxException ex) {
                throw new OseeCoreException((Throwable)ex, "Error creating URI for [%s]", new Object[]{modelName});
            }
        }

        public String getName() {
            return this.filename;
        }

        public boolean isCompressed() {
            return false;
        }
    }
}

