/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.TxDataStore;
import org.eclipse.osee.orcs.core.internal.transaction.TransactionBuilderImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TxCallableFactory;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class TransactionFactoryImpl
implements TransactionFactory {
    private final OrcsSession session;
    private final TxDataManager txDataManager;
    private final TxCallableFactory txCallableFactory;
    private final OrcsApi orcsApi;
    private final QueryFactory queryFactory;
    private final OrcsBranch orcsBranch;
    private final KeyValueOps keyValueOps;
    private final TxDataStore txDataStore;
    private final TransactionQuery transactionQuery;

    public TransactionFactoryImpl(OrcsSession session, TxDataManager txDataManager, TxCallableFactory txCallableFactory, OrcsApi orcsApi, OrcsBranch orcsBranch, KeyValueOps keyValueOps, TxDataStore txDataStore) {
        this.session = session;
        this.txDataManager = txDataManager;
        this.txCallableFactory = txCallableFactory;
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.orcsBranch = orcsBranch;
        this.keyValueOps = keyValueOps;
        this.txDataStore = txDataStore;
        this.transactionQuery = this.queryFactory.transactionQuery();
    }

    public CancellableCallable<Integer> purgeTransaction(Collection<? extends TransactionId> transactions) {
        return this.txCallableFactory.purgeTransactions(this.session, transactions);
    }

    public TransactionBuilder createTransaction(BranchId branch, UserId author, String comment) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNull((Object)author, (String)"author");
        Conditions.checkNotNullOrEmpty((String)comment, (String)"comment");
        if (!((BranchQuery)this.queryFactory.branchQuery().andId(branch)).exists()) {
            throw new ItemDoesNotExist("BranchId %s does not exist", new Object[]{branch});
        }
        TxData txData = this.txDataManager.createTxData(this.session, branch);
        TransactionBuilderImpl orcsTxn = new TransactionBuilderImpl(this.txCallableFactory, this.txDataManager, txData, this.orcsApi, this.keyValueOps);
        orcsTxn.setComment(comment);
        orcsTxn.setAuthor(author);
        return orcsTxn;
    }

    public Callable<Void> setTransactionComment(TransactionId transaction, String comment) {
        return this.txCallableFactory.setTransactionComment(this.session, transaction, comment);
    }

    public List<ChangeItem> compareTxs(TransactionId txId1, TransactionId txId2) {
        TransactionReadable sourceTx = this.getTx(txId1);
        TransactionReadable destinationTx = this.getTx(txId2);
        try {
            return this.orcsBranch.compareBranch((TransactionToken)sourceTx, (TransactionToken)destinationTx);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public List<ChangeItem> comparedToParent(BranchId branch) {
        BranchId parentBranch = ((Branch)((BranchQuery)this.queryFactory.branchQuery().andId(branch)).getResults().getExactlyOne()).getParentBranch();
        TransactionId sourceTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsHead(branch)).getResultsAsIds().getExactlyOne();
        TransactionId destionationTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsHead(parentBranch)).getResultsAsIds().getExactlyOne();
        return this.compareTxs(sourceTx, destionationTx);
    }

    public List<ChangeItem> comparedToPreviousTx(TransactionToken txId) {
        TransactionId startTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsPriorTx(txId)).getResultsAsIds().getExactlyOne();
        return this.compareTxs(startTx, (TransactionId)txId);
    }

    public boolean replaceWithBaselineTxVersion(UserId userId, BranchId branchId, TransactionId txId, ArtifactId artId, String comment) {
        boolean introduced = false;
        ArtifactReadable baselineArtifact = (ArtifactReadable)this.queryFactory.fromBranch(branchId).fromTransaction(txId).andId(artId).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (!userId.isValid() || !baselineArtifact.isValid()) {
            throw new OseeCoreException("%s Error - The user and/or baseline artifact were not found.", new Object[]{comment});
        }
        TransactionBuilder tx = this.createTransaction(branchId, userId, comment);
        ArtifactReadable destination = (ArtifactReadable)this.queryFactory.fromBranch(branchId).includeDeletedArtifacts().andId(artId).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        tx.replaceWithVersion(baselineArtifact, destination);
        tx.commit();
        introduced = true;
        return introduced;
    }

    public boolean purgeTxs(String txIds) {
        ResultSet results;
        boolean modified = false;
        List txsToDelete = Collections.fromString((String)txIds, TransactionId::valueOf);
        if (!txsToDelete.isEmpty() && !(results = ((TransactionQuery)this.transactionQuery.andTxIds((Collection)txsToDelete)).getResults()).isEmpty()) {
            this.checkAllTxsFound("Purge Transaction", txsToDelete, (ResultSet<? extends TransactionId>)results);
            ArrayList list = Lists.newArrayList((Iterable)results);
            try {
                this.purgeTransaction((Collection<? extends TransactionId>)list).call();
            }
            catch (Exception ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
            modified = true;
        }
        return modified;
    }

    public boolean setTxComment(TransactionId txId, String comment) {
        TransactionReadable tx = this.getTx(txId);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getComment(), (Object)comment)) {
            this.setTransactionComment((TransactionId)tx, comment);
            modified = true;
        }
        return modified;
    }

    public ResultSet<TransactionReadable> getAllTxs() {
        return this.transactionQuery.getResults();
    }

    public TransactionReadable getTx(TransactionId tx) {
        if (tx instanceof TransactionReadable) {
            return (TransactionReadable)tx;
        }
        return (TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(tx)).getResults().getExactlyOne();
    }

    private void checkAllTxsFound(String opName, List<TransactionId> txIds, ResultSet<? extends TransactionId> result) {
        List difference;
        if (txIds.size() != result.size() && !(difference = Collections.setComplement(txIds, (Collection)result.getList())).isEmpty()) {
            throw new OseeNotFoundException("%s Error - The following transactions from %s were not found - txs %s - Please remove them from the request and try again.", new Object[]{opName, txIds, difference});
        }
    }

    public int[] purgeUnusedBackingDataAndTransactions() {
        return this.txDataStore.purgeUnusedBackingDataAndTransactions();
    }

    public boolean setTransactionCommitArtifact(TransactionId trans, ArtifactToken commitArt) {
        TransactionReadable tx = this.getTx(trans);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getCommitArt(), (Object)commitArt)) {
            this.txCallableFactory.setTransactionCommitArtifact(this.session, trans, commitArt);
            modified = true;
        }
        return modified;
    }
}

