/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.search.TupleQuery;

public class ApplicabilityQueryImpl
implements ApplicabilityQuery {
    private final TupleQuery tupleQuery;
    private final ApplicabilityDsQuery applicabilityDsQuery;
    private final TransactionQuery transactionQuery;
    private final BranchQuery branchQuery;
    private final QueryFactory queryFactory;

    public ApplicabilityQueryImpl(ApplicabilityDsQuery applicabilityDsQuery, QueryFactory queryFactory) {
        this.tupleQuery = queryFactory.tupleQuery();
        this.applicabilityDsQuery = applicabilityDsQuery;
        this.transactionQuery = queryFactory.transactionQuery();
        this.branchQuery = queryFactory.branchQuery();
        this.queryFactory = queryFactory;
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId, BranchId branch) {
        return this.applicabilityDsQuery.getApplicabilityToken(artId, branch);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> artIds, BranchId branch) {
        return this.applicabilityDsQuery.getApplicabilityTokens(artIds, branch);
    }

    public HashMap<Long, ApplicabilityToken> getApplicabilityTokens(BranchId branch) {
        HashMap<Long, ApplicabilityToken> tokens = new HashMap<Long, ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            ApplicabilityToken applicabilityToken = tokens.put((Long)id, new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ViewApplicability, branch, consumer);
        if (tokens.isEmpty()) {
            tokens.put(ApplicabilityToken.BASE.getId(), ApplicabilityToken.BASE);
        }
        return tokens;
    }

    public HashMap<Long, ApplicabilityToken> getApplicabilityTokens(BranchId branch1, BranchId branch2) {
        HashMap<Long, ApplicabilityToken> tokens = new HashMap<Long, ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            ApplicabilityToken applicabilityToken = tokens.put((Long)id, new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ViewApplicability, branch1, consumer);
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ViewApplicability, branch2, consumer);
        return tokens;
    }

    public List<ApplicabilityId> getApplicabilitiesReferenced(ArtifactId artifact, BranchId branch) {
        LinkedList<ApplicabilityId> appIds = new LinkedList<ApplicabilityId>();
        Iterable existingAppIds = this.tupleQuery.getTuple2(CoreTupleTypes.ArtifactReferenceApplicabilityType, branch, (Object)artifact);
        for (ApplicabilityId tuple2 : existingAppIds) {
            appIds.add(tuple2);
        }
        return appIds;
    }

    public List<ApplicabilityToken> getApplicabilityReferenceTokens(ArtifactId artifact, BranchId branch) {
        LinkedList<ApplicabilityToken> tokens = new LinkedList<ApplicabilityToken>();
        this.tupleQuery.getTuple2NamedId(CoreTupleTypes.ArtifactReferenceApplicabilityType, branch, (Object)artifact, (e2, value) -> {
            boolean bl = tokens.add(ApplicabilityToken.valueOf((long)e2, (String)value));
        });
        return tokens;
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId artId, BranchId branch) {
        ArrayList<ApplicabilityToken> result = new ArrayList<ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            boolean bl = result.add(new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2KeyValuePair(CoreTupleTypes.ViewApplicability, (Object)artId, branch, consumer);
        return result;
    }

    public List<FeatureDefinition> getFeatureDefinitionData(BranchId branch) {
        BranchId branchToUse = branch;
        Branch br = (Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne();
        if (br.getBranchType().equals((Object)BranchType.MERGE)) {
            branchToUse = br.getParentBranch();
        }
        List featureDefinitionArts = this.queryFactory.fromBranch(branchToUse).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.FeatureDefinition}).getResults().getList();
        ArrayList<FeatureDefinition> featureDefinition = new ArrayList<FeatureDefinition>();
        for (ArtifactReadable art : featureDefinitionArts) {
            String json = art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
            json = json.replaceAll("\"type\"", "\"valueType\"");
            FeatureDefinition[] readValue = (FeatureDefinition[])JsonUtil.readValue((String)json, FeatureDefinition[].class);
            featureDefinition.addAll(Arrays.asList(readValue));
        }
        return featureDefinition;
    }

    public Map<String, List<String>> getNamedViewApplicabilityMap(BranchId branch, ArtifactId viewId) {
        TreeMap<String, List<String>> toReturn = new TreeMap<String, List<String>>();
        List<ApplicabilityToken> appTokens = this.getViewApplicabilityTokens(viewId, branch);
        for (ApplicabilityToken app : appTokens) {
            String[] split;
            if (app.getName().equalsIgnoreCase("Base") || app.getName().contains("|") || app.getName().contains("&") || app.getName().toLowerCase().contains("config") || (split = app.getName().split("=")).length != 2) continue;
            String name = split[0].trim();
            String value = split[1].trim();
            if (toReturn.containsKey(name)) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll((Collection)toReturn.get(name));
                list.add(value);
                toReturn.put(name, list);
                continue;
            }
            toReturn.put(name, Arrays.asList(value));
        }
        return toReturn;
    }

    public boolean applicabilityExistsOnBranchView(BranchId branch, ArtifactId viewId, String applicability) {
        ArrayList tuples = new ArrayList();
        this.queryFactory.tupleQuery().getTuple2GammaFromE1E2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId, (Object)applicability, tuples::add);
        return !tuples.isEmpty();
    }

    public String getExistingFeatureApplicability(BranchId branch, ArtifactId viewId, String featureName) {
        String existingAppl = "";
        for (String appl : this.queryFactory.tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId)) {
            if (!appl.startsWith(String.valueOf(featureName) + " =")) continue;
            existingAppl = appl;
        }
        return existingAppl;
    }

    public boolean featureExistsOnBranch(BranchId branch, String featureName) {
        ArtifactReadable jsonArtifact = (ArtifactReadable)this.queryFactory.fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.FeatureDefinition}).andExists(new AttributeTypeId[]{CoreAttributeTypes.GeneralStringData}).getResults().getAtMostOneOrNull();
        String json = jsonArtifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
        boolean returnValue = json.contains("\"name\": \"" + featureName + "\"");
        return returnValue;
    }

    public boolean featureValueIsValid(BranchId branch, String featureName, String featureValue) {
        return true;
    }

    public List<ArtifactToken> getViewForBranch(BranchId branch) {
        return this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.BranchView}).asArtifactTokens();
    }

    public boolean viewExistsOnBranch(BranchId branch, ArtifactId viewId) {
        Boolean returnValue = false;
        for (ArtifactToken view : this.getViewForBranch(branch)) {
            if (!view.equals(viewId)) continue;
            returnValue = true;
        }
        return returnValue;
    }

    public String getViewTable(BranchId branch, String filter) {
        StringBuilder html = new StringBuilder("<!DOCTYPE html><html><head><style> table { border-spacing: 0px } th,td { padding: 3px; } </style></head><body>");
        html.append(String.format("<h1>Features for branch [%s]</h1>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
        html.append("<table border=\"1\">");
        List<ArtifactToken> branchViews = this.getViewForBranch(branch);
        if (Strings.isValid((String)filter)) {
            branchViews.removeIf(art -> art.getName().matches(filter));
        }
        List<FeatureDefinition> featureDefinitionData = this.getFeatureDefinitionData(branch);
        Collections.sort(featureDefinitionData, new Comparator<FeatureDefinition>(){

            @Override
            public int compare(FeatureDefinition obj1, FeatureDefinition obj2) {
                return obj1.getName().compareTo(obj2.getName());
            }
        });
        this.printColumnHeadings(html, branchViews, branch);
        HashMap<ArtifactId, Map<String, List<String>>> branchViewsMap = new HashMap<ArtifactId, Map<String, List<String>>>();
        for (ArtifactId artifactId : branchViews) {
            branchViewsMap.put(artifactId, this.getNamedViewApplicabilityMap(branch, artifactId));
        }
        for (FeatureDefinition featureDefinition : featureDefinitionData) {
            html.append("<tr>");
            html.append(String.format("<td>%s</td>", featureDefinition.getName()));
            html.append(String.format("<td>%s</td>", featureDefinition.getDescription()));
            for (ArtifactId artifactId : branchViews) {
                List list = (List)((Map)branchViewsMap.get(artifactId)).get(featureDefinition.getName());
                if (list != null) {
                    html.append("<td>" + org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", (Iterable)list) + "</td>");
                    continue;
                }
                html.append("<td> </td>");
            }
            html.append("</tr>");
        }
        html.append("</table></body></html>");
        return html.toString();
    }

    private void printColumnHeadings(StringBuilder html, List<ArtifactToken> branchViews, BranchId branch) {
        html.append("<tr>");
        html.append("<th>Feature Name</th>");
        html.append("<th>Feature Description</th>");
        for (ArtifactToken artId : branchViews) {
            html.append(String.format("<th>%s</th>", artId.getName()));
        }
        html.append("</tr>");
    }

    public ArtifactId getVersionConfig(ArtifactId art, BranchId branch) {
        Iterable tuple2 = this.tupleQuery.getTuple2Raw(CoreTupleTypes.VersionConfig, branch, (Object)art);
        if (tuple2.iterator().hasNext()) {
            return ArtifactId.valueOf((Long)((Long)tuple2.iterator().next()));
        }
        return ArtifactId.SENTINEL;
    }

    public List<BranchId> getAffectedBranches(Long injectDateMs, Long removalDateMs, List<ApplicabilityId> applicabilityIds, BranchId branch) {
        ArrayList<BranchId> toReturn = new ArrayList<BranchId>();
        Date injection = new Date(injectDateMs);
        Date removal = new Date(removalDateMs);
        List branchList = ((BranchQuery)((BranchQuery)this.branchQuery.andIsOfType(new BranchType[]{BranchType.BASELINE})).andIsChildOf(branch)).getResults().getList();
        HashMap<Long, ApplicabilityId> applicabilityIdsMap = new HashMap<Long, ApplicabilityId>();
        for (ApplicabilityId applicId : applicabilityIds) {
            applicabilityIdsMap.put(applicId.getId(), applicId);
        }
        for (Branch baseBranch : branchList) {
            Date baseDate = ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(baseBranch.getBaselineTx())).getResults().getExactlyOne()).getDate();
            if (!baseDate.after(injection) || removalDateMs != -1L && !baseDate.before(removal)) continue;
            block2: for (ArtifactId artifactId : this.getViewForBranch((BranchId)baseBranch)) {
                List<ApplicabilityToken> viewApplicabilityTokens = this.getViewApplicabilityTokens(artifactId, (BranchId)baseBranch);
                for (ApplicabilityToken applicToken : viewApplicabilityTokens) {
                    if (!applicabilityIdsMap.containsKey(applicToken.getId())) continue;
                    toReturn.add(BranchId.create((Long)baseBranch.getId(), (ArtifactId)artifactId));
                    continue block2;
                }
            }
        }
        return toReturn;
    }

    public List<BranchId> getAffectedBranches(TransactionId injectionTx, TransactionId removalTx, List<ApplicabilityId> applicabilityIds, BranchId branch) {
        long timeInjectionMs = ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(injectionTx)).getResults().getExactlyOne()).getDate().getTime();
        long timeRemovalMs = removalTx.isInvalid() ? -1L : ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(removalTx)).getResults().getExactlyOne()).getDate().getTime();
        return this.getAffectedBranches(timeInjectionMs, timeRemovalMs, applicabilityIds, branch);
    }

    public Set<ArtifactId> getExcludedArtifacts(BranchId branch, ArtifactId view) {
        return this.applicabilityDsQuery.getExcludedArtifacts(branch, view);
    }
}

