/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.RelationDataFactory;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeAdjacencies;
import org.eclipse.osee.orcs.core.internal.util.OrcsConditions;

public class RelationFactory {
    private final RelationDataFactory relationDataFactory;

    public RelationFactory(RelationDataFactory relationDataFactory) {
        this.relationDataFactory = relationDataFactory;
    }

    public RelationNodeAdjacencies createRelationContainer() {
        return new RelationNodeAdjacencies();
    }

    public Relation createRelation(RelationData data) {
        return new Relation(data);
    }

    public Relation createRelation(Artifact aNode, RelationTypeToken type, Artifact bNode) {
        return this.createRelation(aNode, type, bNode, "");
    }

    public Relation createRelation(Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale) {
        OrcsConditions.checkBranch(aNode, bNode);
        OrcsConditions.checkRelateSelf(aNode, bNode);
        RelationData data = this.relationDataFactory.createRelationData(type, aNode.getBranch(), (ArtifactId)aNode, (ArtifactId)bNode, rationale);
        return this.createRelation(data);
    }

    public Relation clone(Relation src) {
        RelationData data = this.relationDataFactory.clone(src.getOrcsData());
        return this.createRelation(data);
    }

    public Relation introduce(BranchId branch, RelationData data) {
        RelationData source = this.relationDataFactory.introduce(branch, data);
        return this.createRelation(source);
    }
}

