/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.data.AttributeTypes;

public class PurgeAttributeTypeCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "purge_attribute_type";
    }

    public String getDescription() {
        return "Purges attribute type instances from datastore";
    }

    public String getUsage() {
        return "[force=<TRUE|FALSE>] types=<ATTRIBUTE_TYPE_UUID,...>";
    }

    public Callable<?> createCallable(final Console console, final ConsoleParameters params) {
        final OrcsTypes orcsTypes = this.orcsApi.getOrcsTypes();
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean found;
                boolean forcePurge = params.getBoolean("force");
                String[] typesToPurge = params.getArray("types");
                console.writeln();
                Set<AttributeTypeId> types = this.getTypes(typesToPurge);
                boolean bl = found = !types.isEmpty();
                if (found) {
                    console.writeln((Object)(!forcePurge ? String.format("Attribute Types: [%s]", types) : String.format("Purging attribute types: [%s]", types)));
                    if (forcePurge && found) {
                        orcsTypes.purgeAttributesByAttributeType(types).call();
                    }
                    console.writeln((Object)(found && !forcePurge ? "To >DELETE Attribute DATA!< add \"force=TRUE\" to confirm." : "Operation finished."));
                } else {
                    console.writeln((Object)"No types found.  Aborting...");
                }
                return null;
            }

            private Set<AttributeTypeId> getTypes(String[] typesToPurge) {
                AttributeTypes attributeTypes = orcsTypes.getAttributeTypes();
                HashSet<AttributeTypeId> toReturn = new HashSet<AttributeTypeId>();
                String[] stringArray = typesToPurge;
                int n = typesToPurge.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    try {
                        Long typeId = Long.valueOf(uuid);
                        AttributeTypeId type = (AttributeTypeId)attributeTypes.get(typeId);
                        console.writeln("Type [%s] found.", new Object[]{type});
                        toReturn.add(type);
                    }
                    catch (OseeArgumentException ex) {
                        console.writeln("Type [%s] NOT found.", new Object[]{uuid});
                        console.writeln((Throwable)ex);
                    }
                    ++n2;
                }
                return toReturn;
            }
        };
    }
}

