/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.CharacterBackedAttribute;

@OseeAttribute(value="FloatingPointAttribute")
public class FloatingPointAttribute
extends CharacterBackedAttribute<Double> {
    public static final String NAME = FloatingPointAttribute.class.getSimpleName();
    private static final Double DEFAULT_DOUBLE = Double.MIN_VALUE;

    public FloatingPointAttribute(Long id) {
        super(id);
    }

    @Override
    public Double convertStringToValue(String value) {
        Double toReturn = null;
        toReturn = this.isValidDouble(value) ? Double.valueOf(value) : this.getDefaultValue();
        return toReturn;
    }

    public Double getDefaultValue() {
        Double toReturn = DEFAULT_DOUBLE;
        String defaultValue = this.getDefaultValueFromMetaData();
        if (this.isValidDouble(defaultValue)) {
            toReturn = Double.valueOf(defaultValue);
        }
        return toReturn;
    }

    private boolean isValidDouble(String value) {
        boolean result = false;
        if (Strings.isValid((String)value)) {
            try {
                Double.parseDouble(value);
                result = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }
}

