/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.BinaryAttribute;

@OseeAttribute(value="CompressedContentAttribute")
public final class CompressedContentAttribute
extends BinaryAttribute<InputStream> {
    public static final String NAME = CompressedContentAttribute.class.getSimpleName();

    public CompressedContentAttribute(Long id) {
        super(id);
    }

    @Override
    public InputStream getValue() {
        return Lib.byteBufferToInputStream((ByteBuffer)this.getDataProxy().getValueAsBytes());
    }

    @Override
    public boolean subClassSetValue(InputStream value) {
        return this.setValueFromInputStream(value);
    }

    @Override
    public boolean setValueFromInputStream(InputStream value) {
        boolean response = false;
        try {
            if (value == null) {
                response = this.getDataProxy().setValue(null);
            } else {
                byte[] data = Lib.inputStreamToBytes((InputStream)value);
                response = this.getDataProxy().setValue(ByteBuffer.wrap(data));
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        if (response) {
            this.markAsChanged(ModificationType.MODIFIED);
        }
        return response;
    }

    @Override
    public InputStream convertStringToValue(String value) {
        try {
            return Lib.stringToInputStream((String)value);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    @Override
    protected void uponInitialize() {
        this.getDataProxy().setDisplayableString(this.getAttributeType().getName());
    }
}

