/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeContainer;
import org.eclipse.osee.orcs.data.AttributeTypes;

public abstract class AttributeImpl<T>
extends BaseId
implements Comparable<AttributeImpl<T>>,
Attribute<T> {
    private AttributeTypes attributeTypeCache;
    private Reference<AttributeContainer> containerReference;
    private final Log logger = null;
    private AttributeData<T> attributeData;

    public AttributeImpl(Long id) {
        super(id);
    }

    @Override
    public void internalInitialize(AttributeTypes attributeTypeCache, Reference<AttributeContainer> containerReference, AttributeData<T> attributeData, boolean isDirty, boolean setDefaultValue) {
        this.attributeTypeCache = attributeTypeCache;
        this.containerReference = containerReference;
        this.attributeData = attributeData;
        if (setDefaultValue) {
            this.setToDefaultValue();
        }
        this.getOrcsData().calculateDirtyState(isDirty);
        this.uponInitialize();
    }

    protected Log getLogger() {
        return this.logger;
    }

    @Override
    public AttributeData<T> getOrcsData() {
        return this.attributeData;
    }

    @Override
    public void setOrcsData(AttributeData<T> data) {
        this.attributeData = data;
    }

    protected void uponInitialize() {
    }

    private void markAsNewOrChanged() {
        if (this.isInDb()) {
            this.markAsChanged(ModificationType.MODIFIED);
        } else {
            this.markAsChanged(ModificationType.NEW);
        }
    }

    @Override
    public void setValue(T value) {
        if (this.subClassSetValue(value)) {
            this.markAsNewOrChanged();
        }
    }

    @Override
    public boolean setFromString(String value) {
        Conditions.checkNotNull((Object)value, (String)"Attribute value", (String)"attribute id [%s]", (Object[])new Object[]{this.getId()});
        boolean response = this.subClassSetValue(this.convertStringToValue(value));
        if (response) {
            this.markAsNewOrChanged();
        }
        return response;
    }

    @Override
    public final void resetToDefaultValue() {
        this.getOrcsData().setModType(ModificationType.MODIFIED);
        this.setToDefaultValue();
    }

    protected void setToDefaultValue() {
        String defaultValue = this.attributeTypeCache.getDefaultValue((AttributeTypeId)this.attributeData.getType());
        if (defaultValue != null) {
            this.subClassSetValue(this.convertStringToValue(defaultValue));
        }
    }

    @Override
    public boolean setValueFromInputStream(InputStream value) {
        Conditions.checkNotNull((Object)value, (String)"Attribute value", (String)"attribute id [%s]", (Object[])new Object[]{this.getId()});
        boolean success = false;
        try {
            success = this.setFromString(Lib.inputStreamToString((InputStream)value));
            if (success) {
                this.markAsNewOrChanged();
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return success;
    }

    protected abstract boolean subClassSetValue(T var1);

    public abstract T getValue();

    public String getDisplayableString() {
        return this.getDataProxy().getDisplayableString();
    }

    public String toString() {
        try {
            return this.getDisplayableString();
        }
        catch (OseeCoreException ex) {
            return Lib.exceptionToString((Exception)((Object)ex));
        }
    }

    public DataProxy getDataProxy() {
        return this.getOrcsData().getDataProxy();
    }

    public boolean isDirty() {
        return this.getOrcsData().isDirty();
    }

    protected void markAsChanged(ModificationType modificationType) {
        this.setDirtyFlag(true);
        this.getOrcsData().setModType(modificationType);
    }

    @Override
    public void clearDirty() {
        this.setDirtyFlag(false);
    }

    private void setDirtyFlag(boolean dirty) {
        this.getOrcsData().calculateDirtyState(dirty);
    }

    @Override
    public AttributeContainer getContainer() {
        if (this.containerReference.get() == null) {
            throw new OseeStateException("Attribute parent has been garbage collected", new Object[0]);
        }
        return this.containerReference.get();
    }

    protected String getDefaultValueFromMetaData() {
        return this.attributeTypeCache.getDefaultValue((AttributeTypeId)this.getAttributeType());
    }

    public AttributeTypeToken getAttributeType() {
        return (AttributeTypeToken)this.attributeData.getType();
    }

    public boolean isOfType(AttributeTypeId otherAttributeType) {
        return this.getAttributeType().equals(otherAttributeType);
    }

    public void unDelete() {
        this.getOrcsData().setModType(this.getOrcsData().getPreviousModType());
    }

    @Override
    public final void setArtifactDeleted() {
        this.markAsChanged(ModificationType.ARTIFACT_DELETED);
    }

    public final void delete() {
        if (this.isInDb()) {
            this.markAsChanged(ModificationType.DELETED);
        } else {
            this.getContainer().remove(this.getAttributeType(), this);
        }
    }

    public ModificationType getModificationType() {
        return this.getOrcsData().getModType();
    }

    public boolean isDeleteAllowed() {
        try {
            return !this.isDeleted() && this.getContainer().getAttributeCount(this.getAttributeType()) > this.attributeTypeCache.getMinOccurrences((AttributeTypeId)this.getAttributeType());
        }
        catch (OseeCoreException oseeCoreException) {
            return false;
        }
    }

    public void purge() {
        this.getDataProxy().purge();
    }

    public void markAsPurged() {
        this.getOrcsData().setModType(ModificationType.DELETED);
        this.setDirtyFlag(false);
    }

    public boolean isInDb() {
        return this.getGammaId().isValid();
    }

    public GammaId getGammaId() {
        return this.getOrcsData().getVersion().getGammaId();
    }

    public void internalSetGammaId(GammaId gammaId) {
        this.getOrcsData().getVersion().setGammaId(gammaId);
    }

    public void internalSetAttributeId(int attrId) {
        this.getOrcsData().setLocalId(attrId);
    }

    public void replaceWithVersion(GammaId gammaId) {
        this.internalSetModificationType(ModificationType.REPLACED_WITH_VERSION);
        this.getOrcsData().getVersion().setGammaId(gammaId);
        this.setDirtyFlag(true);
    }

    public void internalSetModificationType(ModificationType modificationType) {
        Conditions.checkNotNull((Object)modificationType, (String)"modification type");
        this.getOrcsData().setModType(modificationType);
    }

    public void internalSetDeletedFromRemoteEvent() {
        this.internalSetModificationType(ModificationType.DELETED);
    }

    @Override
    public int compareTo(AttributeImpl<T> other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public String convertToStorageString(T rawValue) {
        return rawValue == null ? "" : rawValue.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Id) {
            return this.getId().equals(((Id)obj).getId());
        }
        if (obj instanceof Long) {
            return this.getId().equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

