/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.data.AttributeTypes;

public class CriteriaAttributeKeywords
extends Criteria {
    private final AttributeTypes attributeTypeCache;
    private final Collection<AttributeTypeId> attributeTypes;
    private final Collection<String> values;
    private final QueryOption[] options;
    private final boolean includeAllTypes;

    public CriteriaAttributeKeywords(boolean includeAllTypes, Collection<AttributeTypeId> attributeTypes, AttributeTypes attributeTypeCache, Collection<String> values, QueryOption ... options) {
        this.includeAllTypes = includeAllTypes;
        this.attributeTypeCache = attributeTypeCache;
        this.attributeTypes = attributeTypes;
        this.values = values;
        this.options = options;
    }

    public CriteriaAttributeKeywords(boolean includeAllTypes, Collection<AttributeTypeId> attributeTypes, AttributeTypes attributeTypeCache, String value, QueryOption ... options) {
        this(includeAllTypes, attributeTypes, attributeTypeCache, java.util.Collections.singleton(value), options);
    }

    public boolean isIncludeAllTypes() {
        return this.includeAllTypes;
    }

    public Collection<AttributeTypeId> getTypes() {
        return this.attributeTypes;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public QueryOption[] getOptions() {
        return this.options;
    }

    @Override
    public void checkValid(Options options) {
        Conditions.checkNotNullOrEmpty(this.getValues(), (String)"search value");
        Conditions.checkNotNullOrEmpty(this.getTypes(), (String)"attribute types");
        this.checkMultipleValues();
        this.checkNotTaggable();
    }

    @Override
    public String toString() {
        return String.format("CriteriaAttributeKeyword [attributeType=%s, value=%s, options=%s]", this.attributeTypes, Collections.toString((String)",", this.values), Collections.toString((String)",", Arrays.asList(this.options)));
    }

    private void checkMultipleValues() {
        if (this.getTypes().size() > 1 && this.getValues().size() > 1) {
            throw new OseeArgumentException("Multiple values is not valid with multiple types", new Object[0]);
        }
    }

    public void checkNotTaggable() {
        if (!this.includeAllTypes) {
            ArrayList<String> notTaggable = new ArrayList<String>();
            if (this.attributeTypeCache != null) {
                for (AttributeTypeId type : this.attributeTypes) {
                    if (this.attributeTypeCache.isTaggable(type)) continue;
                    notTaggable.add(type.toString());
                }
                if (!notTaggable.isEmpty()) {
                    throw new OseeArgumentException("Attribute types [%s] is not taggable", new Object[]{notTaggable.toString()});
                }
            }
        }
    }
}

