/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osee.framework.core.enums.OperationBehavior;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class WeightedCompositeOperation
extends AbstractOperation {
    public static final Double EMPTY_WEIGHT_HINT = null;
    private final List<IStatus> statuses = new ArrayList<IStatus>();
    private final List<Pair<Double, ? extends IOperation>> operations;
    private final OperationBehavior behavior;
    private final double runningTotal;
    private final int itemsWithHints;

    public WeightedCompositeOperation(String name, String pluginId, OperationBehavior behavior, OperationLogger logger, double runningTotal, int itemsWithHints, List<Pair<Double, ? extends IOperation>> operations) {
        super(name, pluginId, logger);
        this.operations = operations;
        this.behavior = behavior;
        this.runningTotal = runningTotal;
        this.itemsWithHints = itemsWithHints;
    }

    @Override
    protected void doWork(IProgressMonitor parentMonitor) throws Exception {
        Conditions.checkNotNullOrEmpty(this.operations, (String)"sub-operations");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)parentMonitor, (String)this.getName(), (int)Integer.MAX_VALUE);
        try {
            this.processSubWork(subMonitor);
        }
        finally {
            subMonitor.done();
        }
    }

    private void processSubWork(SubMonitor subMonitor) throws Exception {
        double averageWeightHint = this.getAverageWeightHint();
        double sumOfAllWeights = this.computeSumOfTotalWeights(averageWeightHint);
        for (Pair<Double, ? extends IOperation> entry : this.operations) {
            IStatus status;
            WeightedCompositeOperation.checkForCancelledStatus((IProgressMonitor)subMonitor);
            double actualWeight = this.getActualWeight((Double)entry.getFirst(), averageWeightHint, sumOfAllWeights);
            IOperation operation = (IOperation)entry.getSecond();
            int subTicks = this.calculateWork(actualWeight);
            SubMonitor childMonitor = subMonitor.newChild(subTicks);
            childMonitor.subTask(operation.getName());
            try {
                status = operation.run(childMonitor);
            }
            finally {
                childMonitor.done();
            }
            if (this.behavior == OperationBehavior.TerminateOnError && status.getSeverity() == 4) {
                this.setStatus(status);
                return;
            }
            if (status.getSeverity() == 0) continue;
            this.statuses.add(status);
        }
        this.setStatus(this.computeCombinedStatus());
    }

    private double getAverageWeightHint() {
        double average;
        if (this.itemsWithHints > 0) {
            average = this.runningTotal / (double)this.itemsWithHints;
        } else {
            int total = this.operations.size();
            average = 1.0 / (double)total;
        }
        return average;
    }

    private double computeSumOfTotalWeights(double averageWeightHint) {
        int totalItems = this.operations.size();
        double itemsWithoutHints = totalItems - this.itemsWithHints;
        return this.runningTotal + itemsWithoutHints * averageWeightHint;
    }

    private double getActualWeight(Double initialWeightHint, double averageWeightHint, double sumOfAllWeights) {
        Double value = initialWeightHint;
        if (value == EMPTY_WEIGHT_HINT) {
            value = averageWeightHint;
        }
        return value / sumOfAllWeights;
    }

    private IStatus computeCombinedStatus() {
        IStatus toReturn = null;
        if (!this.statuses.isEmpty()) {
            if (this.statuses.size() > 1) {
                StringBuilder strB = new StringBuilder();
                for (IStatus status : this.statuses) {
                    strB.append(status.getMessage());
                    strB.append("\n");
                }
                IStatus[] statusArray = this.statuses.toArray(new IStatus[this.statuses.size()]);
                toReturn = new MultiStatus(this.getPluginId(), 0, statusArray, strB.toString(), null);
            } else {
                toReturn = this.statuses.get(0);
            }
        }
        return toReturn;
    }
}

