/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.OrcsTokenService;
import org.eclipse.osee.framework.core.data.OrcsTypeTokenProvider;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public final class OrcsTokenServiceImpl
implements OrcsTokenService {
    private final Map<Long, ArtifactTypeToken> artifactTypes = new ConcurrentHashMap<Long, ArtifactTypeToken>();
    private final Map<Long, AttributeTypeToken> attributeTypes = new ConcurrentHashMap<Long, AttributeTypeToken>();
    private final Map<Long, RelationTypeToken> relationTypes = new ConcurrentHashMap<Long, RelationTypeToken>();

    public OrcsTokenServiceImpl() {
        new CoreAttributeTypes().registerTypes(this);
    }

    public void addTypeTokenProvider(OrcsTypeTokenProvider typeProvider) {
        typeProvider.registerTypes(this);
    }

    @Override
    public ArtifactTypeToken getArtifactType(Long id) {
        ArtifactTypeToken artifactType = this.artifactTypes.get(id);
        if (artifactType == null) {
            throw new OseeTypeDoesNotExist("Artifact type [%s] is not available.", id);
        }
        return artifactType;
    }

    @Override
    public AttributeTypeToken getAttributeType(Long id) {
        AttributeTypeToken attributeType = this.attributeTypes.get(id);
        if (attributeType == null) {
            throw new OseeTypeDoesNotExist("Attribute type [%s] is not available.", id);
        }
        return attributeType;
    }

    @Override
    public RelationTypeToken getRelationType(Long id) {
        RelationTypeToken relationType = this.relationTypes.get(id);
        if (relationType == null) {
            throw new OseeTypeDoesNotExist("Relation type [%s] is not available.", id);
        }
        return relationType;
    }

    @Override
    public ArtifactTypeToken getArtifactTypeOrSentinel(Long id) {
        ArtifactTypeToken artifactType = this.artifactTypes.get(id);
        if (artifactType == null) {
            return ArtifactTypeToken.SENTINEL;
        }
        return artifactType;
    }

    @Override
    public AttributeTypeToken getAttributeTypeOrSentinel(Long id) {
        AttributeTypeToken attributeType = this.attributeTypes.get(id);
        if (attributeType == null) {
            return AttributeTypeToken.SENTINEL;
        }
        return attributeType;
    }

    @Override
    public RelationTypeToken getRelationTypeOrSentinel(Long id) {
        RelationTypeToken relationType = this.relationTypes.get(id);
        if (relationType == null) {
            return RelationTypeToken.SENTINEL;
        }
        return relationType;
    }

    @Override
    public void registerArtifactType(ArtifactTypeToken artifactType) {
        if (this.artifactTypes.putIfAbsent(artifactType.getId(), artifactType) != null) {
            throw new OseeArgumentException("An artifact type with the id %s has already been registered.", new Object[]{artifactType});
        }
        this.artifactTypes.put(artifactType.getId(), artifactType);
    }

    @Override
    public void registerAttributeType(AttributeTypeToken attributeType) {
        if (this.attributeTypes.putIfAbsent(attributeType.getId(), attributeType) != null) {
            throw new OseeArgumentException("An attribute type with the id %s has already been registered.", new Object[]{attributeType});
        }
        this.attributeTypes.put(attributeType.getId(), attributeType);
    }

    @Override
    public void registerRelationType(RelationTypeToken relationType) {
        if (this.relationTypes.putIfAbsent(relationType.getId(), relationType) != null) {
            throw new OseeArgumentException("A relation type with the id %s has already been registered.", new Object[]{relationType});
        }
        this.relationTypes.put(relationType.getId(), relationType);
    }

    public void start() {
    }
}

