/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.IdSerializer;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@JsonSerialize(using=IdSerializer.class)
public interface ArtifactId
extends Id {
    public static final ArtifactId SENTINEL = ArtifactId.valueOf(Id.SENTINEL);

    default public Long getUuid() {
        return this.getId();
    }

    public static ArtifactId valueOf(String id) {
        Conditions.assertTrue((boolean)Strings.isNumeric((String)id), (String)"id is not numeric [%s]", (Object[])new Object[]{id});
        return (ArtifactId)Id.valueOf((String)id, ArtifactId::valueOf);
    }

    public static ArtifactId valueOf(Id id) {
        if (id instanceof ArtifactId) {
            return (ArtifactId)id;
        }
        return ArtifactId.valueOf(id.getId());
    }

    public static ArtifactId valueOf(int id) {
        return ArtifactId.valueOf(Long.valueOf(id));
    }

    public static ArtifactId valueOf(Long id) {
        final class ArtifactIdImpl
        extends BaseId
        implements ArtifactId,
        Comparable<ArtifactId> {
            private final Long id;

            public Long getId() {
                return this.id;
            }

            public ArtifactIdImpl(Long artId) {
                super(artId);
                this.id = artId;
            }

            @Override
            public int compareTo(ArtifactId o) {
                return this.getId().compareTo(o.getId());
            }
        }
        return new ArtifactIdImpl(id);
    }
}

